/*
 * Decompiled with CFR 0.152.
 */
package com.envisioniot.enos.event_service.vo.condition;

import com.envisioniot.enos.event_service.vo.condition.AbstractCondition;
import com.envisioniot.enos.event_service.vo.condition.AndCondition;
import com.envisioniot.enos.event_service.vo.condition.NotCondition;
import com.envisioniot.enos.event_service.vo.condition.OrCondition;
import com.envisioniot.enos.event_service.vo.condition.RangeCondition;
import com.envisioniot.enos.event_service.vo.condition.RelativeCondition;
import com.envisioniot.enos.event_service.vo.condition.SimpleCondition;
import com.envisioniot.enos.event_service.vo.condition.operator.RangeOperator;
import com.envisioniot.enos.event_service.vo.condition.operator.SimpleOperator;
import java.util.List;

public class ConditionFactory {
    public static <T> SimpleCondition createSimpleEQ(String name, T value) {
        SimpleCondition<T> simpleCondition = new SimpleCondition<T>(name, SimpleOperator.EQ, value);
        return simpleCondition;
    }

    public static <T> SimpleCondition createSimpleNE(String name, T value) {
        SimpleCondition<T> simpleCondition = new SimpleCondition<T>(name, SimpleOperator.NE, value);
        return simpleCondition;
    }

    public static <T> SimpleCondition createSimpleGT(String name, T value) {
        SimpleCondition<T> simpleCondition = new SimpleCondition<T>(name, SimpleOperator.GT, value);
        return simpleCondition;
    }

    public static <T> SimpleCondition createSimpleGTE(String name, T value) {
        SimpleCondition<T> simpleCondition = new SimpleCondition<T>(name, SimpleOperator.GTE, value);
        return simpleCondition;
    }

    public static <T> SimpleCondition createSimpleLT(String name, T value) {
        SimpleCondition<T> simpleCondition = new SimpleCondition<T>(name, SimpleOperator.LT, value);
        return simpleCondition;
    }

    public static <T> SimpleCondition createSimpleLTE(String name, T value) {
        SimpleCondition<T> simpleCondition = new SimpleCondition<T>(name, SimpleOperator.LTE, value);
        return simpleCondition;
    }

    public static SimpleCondition<String> createSimpleCONTAIN(String name, String value) {
        SimpleCondition<String> simpleCondition = new SimpleCondition<String>(name, SimpleOperator.CONTAIN, value);
        return simpleCondition;
    }

    public static RelativeCondition createRelativeEQ(String name, String anotherName) {
        RelativeCondition simpleCondition = new RelativeCondition(name, SimpleOperator.EQ, anotherName);
        return simpleCondition;
    }

    public static RelativeCondition createRelativeNE(String name, String anotherName) {
        RelativeCondition simpleCondition = new RelativeCondition(name, SimpleOperator.NE, anotherName);
        return simpleCondition;
    }

    public static RelativeCondition createRelativeGT(String name, String anotherName) {
        RelativeCondition simpleCondition = new RelativeCondition(name, SimpleOperator.GT, anotherName);
        return simpleCondition;
    }

    public static RelativeCondition createRelativeGTE(String name, String anotherName) {
        RelativeCondition simpleCondition = new RelativeCondition(name, SimpleOperator.GTE, anotherName);
        return simpleCondition;
    }

    public static RelativeCondition createRelativeLT(String name, String anotherName) {
        RelativeCondition simpleCondition = new RelativeCondition(name, SimpleOperator.LT, anotherName);
        return simpleCondition;
    }

    public static RelativeCondition createRelativeLTE(String name, String anotherName) {
        RelativeCondition simpleCondition = new RelativeCondition(name, SimpleOperator.LTE, anotherName);
        return simpleCondition;
    }

    public static RelativeCondition createRelativeCONTAIN(String name, String anotherName) {
        RelativeCondition simpleCondition = new RelativeCondition(name, SimpleOperator.CONTAIN, anotherName);
        return simpleCondition;
    }

    public static <T> RangeCondition createRangeLCRC(String name, T leftValue, T rightValue) {
        RangeCondition<T> rangeCondition = new RangeCondition<T>(name, RangeOperator.RANGE_LCRC, leftValue, rightValue);
        return rangeCondition;
    }

    public static <T> RangeCondition createRangeLCRO(String name, T leftValue, T rightValue) {
        RangeCondition<T> rangeCondition = new RangeCondition<T>(name, RangeOperator.RANGE_LCRO, leftValue, rightValue);
        return rangeCondition;
    }

    public static <T> RangeCondition createRangeLORC(String name, T leftValue, T rightValue) {
        RangeCondition<T> rangeCondition = new RangeCondition<T>(name, RangeOperator.RANGE_LORC, leftValue, rightValue);
        return rangeCondition;
    }

    public static <T> RangeCondition createRangeLORO(String name, T leftValue, T rightValue) {
        RangeCondition<T> rangeCondition = new RangeCondition<T>(name, RangeOperator.RANGE_LORO, leftValue, rightValue);
        return rangeCondition;
    }

    public static NotCondition createNotCondition(AbstractCondition condition) {
        NotCondition notCondition = new NotCondition(condition);
        return notCondition;
    }

    public static AndCondition createAndCondition(List<AbstractCondition> conditions) {
        AndCondition andCondition = new AndCondition(conditions);
        return andCondition;
    }

    public static OrCondition createOrCondition(List<AbstractCondition> conditions) {
        OrCondition orCondition = new OrCondition(conditions);
        return orCondition;
    }
}

