/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.eclipsecollections;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.datatype.eclipsecollections.deser.bag.ImmutableBagDeserializer;
import com.fasterxml.jackson.datatype.eclipsecollections.deser.bag.ImmutableSortedBagDeserializer;
import com.fasterxml.jackson.datatype.eclipsecollections.deser.bag.MutableBagDeserializer;
import com.fasterxml.jackson.datatype.eclipsecollections.deser.bag.MutableSortedBagDeserializer;
import com.fasterxml.jackson.datatype.eclipsecollections.deser.list.FixedSizeListDeserializer;
import com.fasterxml.jackson.datatype.eclipsecollections.deser.list.ImmutableListDeserializer;
import com.fasterxml.jackson.datatype.eclipsecollections.deser.list.MutableListDeserializer;
import com.fasterxml.jackson.datatype.eclipsecollections.deser.map.EclipseMapDeserializer;
import com.fasterxml.jackson.datatype.eclipsecollections.deser.map.EclipseMapDeserializers;
import com.fasterxml.jackson.datatype.eclipsecollections.deser.set.ImmutableSetDeserializer;
import com.fasterxml.jackson.datatype.eclipsecollections.deser.set.ImmutableSortedSetDeserializer;
import com.fasterxml.jackson.datatype.eclipsecollections.deser.set.MutableSetDeserializer;
import com.fasterxml.jackson.datatype.eclipsecollections.deser.set.MutableSortedSetDeserializer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.InternalIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.PrimitiveIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.Bag;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.UnsortedBag;
import org.eclipse.collections.api.bag.primitive.BooleanBag;
import org.eclipse.collections.api.bag.primitive.ByteBag;
import org.eclipse.collections.api.bag.primitive.CharBag;
import org.eclipse.collections.api.bag.primitive.DoubleBag;
import org.eclipse.collections.api.bag.primitive.FloatBag;
import org.eclipse.collections.api.bag.primitive.ImmutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.ImmutableByteBag;
import org.eclipse.collections.api.bag.primitive.ImmutableCharBag;
import org.eclipse.collections.api.bag.primitive.ImmutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.ImmutableFloatBag;
import org.eclipse.collections.api.bag.primitive.ImmutableIntBag;
import org.eclipse.collections.api.bag.primitive.ImmutableLongBag;
import org.eclipse.collections.api.bag.primitive.ImmutableShortBag;
import org.eclipse.collections.api.bag.primitive.IntBag;
import org.eclipse.collections.api.bag.primitive.LongBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.bag.primitive.ShortBag;
import org.eclipse.collections.api.bag.sorted.ImmutableSortedBag;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.bag.sorted.SortedBag;
import org.eclipse.collections.api.collection.FixedSizeCollection;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableByteCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableCharCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableIntCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableLongCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableShortCollection;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.list.FixedSizeList;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.BooleanList;
import org.eclipse.collections.api.list.primitive.ByteList;
import org.eclipse.collections.api.list.primitive.CharList;
import org.eclipse.collections.api.list.primitive.DoubleList;
import org.eclipse.collections.api.list.primitive.FloatList;
import org.eclipse.collections.api.list.primitive.ImmutableBooleanList;
import org.eclipse.collections.api.list.primitive.ImmutableByteList;
import org.eclipse.collections.api.list.primitive.ImmutableCharList;
import org.eclipse.collections.api.list.primitive.ImmutableDoubleList;
import org.eclipse.collections.api.list.primitive.ImmutableFloatList;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;
import org.eclipse.collections.api.list.primitive.ImmutableShortList;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.list.primitive.ShortList;
import org.eclipse.collections.api.ordered.OrderedIterable;
import org.eclipse.collections.api.ordered.ReversibleIterable;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.ImmutableSetIterable;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.MutableSetIterable;
import org.eclipse.collections.api.set.SetIterable;
import org.eclipse.collections.api.set.UnsortedSetIterable;
import org.eclipse.collections.api.set.primitive.BooleanSet;
import org.eclipse.collections.api.set.primitive.ByteSet;
import org.eclipse.collections.api.set.primitive.CharSet;
import org.eclipse.collections.api.set.primitive.DoubleSet;
import org.eclipse.collections.api.set.primitive.FloatSet;
import org.eclipse.collections.api.set.primitive.ImmutableBooleanSet;
import org.eclipse.collections.api.set.primitive.ImmutableByteSet;
import org.eclipse.collections.api.set.primitive.ImmutableCharSet;
import org.eclipse.collections.api.set.primitive.ImmutableDoubleSet;
import org.eclipse.collections.api.set.primitive.ImmutableFloatSet;
import org.eclipse.collections.api.set.primitive.ImmutableIntSet;
import org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import org.eclipse.collections.api.set.primitive.ImmutableShortSet;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.set.primitive.ShortSet;
import org.eclipse.collections.api.set.sorted.ImmutableSortedSet;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.api.set.sorted.SortedSetIterable;

public final class EclipseCollectionsDeserializers
extends Deserializers.Base {
    static final Map<Class<? extends PrimitiveIterable>, JsonDeserializer<?>> PRIMITIVE_DESERIALIZERS = new HashMap();
    static final Set<Class<? extends InternalIterable>> REFERENCE_TYPES = new HashSet<Class<? extends InternalIterable>>();

    public JsonDeserializer<?> findCollectionDeserializer(CollectionType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        if (REFERENCE_TYPES.contains(type.getRawClass())) {
            return this.findReferenceDeserializer((JavaType)type, type.getContentType(), elementTypeDeserializer, elementDeserializer);
        }
        return null;
    }

    public JsonDeserializer<?> findCollectionLikeDeserializer(CollectionLikeType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        if (REFERENCE_TYPES.contains(type.getRawClass())) {
            return this.findReferenceDeserializer((JavaType)type, type.getContentType(), elementTypeDeserializer, elementDeserializer);
        }
        return null;
    }

    public JsonDeserializer<?> findMapDeserializer(MapType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        return this.findBeanDeserializer((JavaType)type, config, beanDesc);
    }

    public JsonDeserializer<?> findMapLikeDeserializer(MapLikeType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        return this.findBeanDeserializer((JavaType)type, config, beanDesc);
    }

    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        JsonDeserializer<?> deserializer = PRIMITIVE_DESERIALIZERS.get(type.getRawClass());
        if (deserializer != null) {
            return deserializer;
        }
        if (REFERENCE_TYPES.contains(type.getRawClass())) {
            return this.findReferenceDeserializer(type, type.containedTypeOrUnknown(0), null, null);
        }
        EclipseMapDeserializer<?, ?, ?, ?> mapDeserializer = EclipseMapDeserializers.createDeserializer(type);
        if (mapDeserializer != null) {
            return mapDeserializer;
        }
        return null;
    }

    private JsonDeserializer<?> findReferenceDeserializer(JavaType containerType, JavaType elementType, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) {
        Class rawClass = containerType.getRawClass();
        if (rawClass == MutableBag.class || rawClass == Bag.class || rawClass == UnsortedBag.class) {
            return new MutableBagDeserializer.Ref(elementType, elementTypeDeserializer, elementDeserializer);
        }
        if (rawClass == ImmutableBag.class) {
            return new ImmutableBagDeserializer.Ref(elementType, elementTypeDeserializer, elementDeserializer);
        }
        if (rawClass == MutableSortedBag.class || rawClass == SortedBag.class) {
            return new MutableSortedBagDeserializer.Ref(elementType, elementTypeDeserializer, elementDeserializer);
        }
        if (rawClass == ImmutableSortedBag.class) {
            return new ImmutableSortedBagDeserializer.Ref(elementType, elementTypeDeserializer, elementDeserializer);
        }
        if (rawClass == MutableList.class || rawClass == MutableCollection.class || rawClass == OrderedIterable.class || rawClass == ReversibleIterable.class || rawClass == RichIterable.class || rawClass == InternalIterable.class) {
            return new MutableListDeserializer.Ref(elementType, elementTypeDeserializer, elementDeserializer);
        }
        if (rawClass == ImmutableList.class || rawClass == ImmutableCollection.class) {
            return new ImmutableListDeserializer.Ref(elementType, elementTypeDeserializer, elementDeserializer);
        }
        if (rawClass == FixedSizeList.class || rawClass == FixedSizeCollection.class) {
            return new FixedSizeListDeserializer.Ref(elementType, elementTypeDeserializer, elementDeserializer);
        }
        if (rawClass == MutableSet.class || rawClass == MutableSetIterable.class || rawClass == SetIterable.class || rawClass == UnsortedSetIterable.class) {
            return new MutableSetDeserializer.Ref(elementType, elementTypeDeserializer, elementDeserializer);
        }
        if (rawClass == ImmutableSet.class || rawClass == ImmutableSetIterable.class) {
            return new ImmutableSetDeserializer.Ref(elementType, elementTypeDeserializer, elementDeserializer);
        }
        if (rawClass == MutableSortedSet.class || rawClass == SortedSetIterable.class) {
            return new MutableSortedSetDeserializer.Ref(elementType, elementTypeDeserializer, elementDeserializer);
        }
        if (rawClass == ImmutableSortedSet.class) {
            return new ImmutableSortedSetDeserializer.Ref(elementType, elementTypeDeserializer, elementDeserializer);
        }
        throw new AssertionError((Object)("Type " + rawClass + " in REFERENCE_TYPES but no deserializer found, should not happen"));
    }

    static {
        REFERENCE_TYPES.add(MutableBag.class);
        REFERENCE_TYPES.add(Bag.class);
        REFERENCE_TYPES.add(UnsortedBag.class);
        REFERENCE_TYPES.add(ImmutableBag.class);
        REFERENCE_TYPES.add(MutableSortedBag.class);
        REFERENCE_TYPES.add(SortedBag.class);
        REFERENCE_TYPES.add(ImmutableSortedBag.class);
        REFERENCE_TYPES.add(MutableList.class);
        REFERENCE_TYPES.add(MutableCollection.class);
        REFERENCE_TYPES.add(OrderedIterable.class);
        REFERENCE_TYPES.add(ReversibleIterable.class);
        REFERENCE_TYPES.add(RichIterable.class);
        REFERENCE_TYPES.add(InternalIterable.class);
        REFERENCE_TYPES.add(ImmutableList.class);
        REFERENCE_TYPES.add(ImmutableCollection.class);
        REFERENCE_TYPES.add(FixedSizeCollection.class);
        REFERENCE_TYPES.add(FixedSizeList.class);
        REFERENCE_TYPES.add(MutableSet.class);
        REFERENCE_TYPES.add(MutableSetIterable.class);
        REFERENCE_TYPES.add(SetIterable.class);
        REFERENCE_TYPES.add(UnsortedSetIterable.class);
        REFERENCE_TYPES.add(ImmutableSet.class);
        REFERENCE_TYPES.add(ImmutableSetIterable.class);
        REFERENCE_TYPES.add(MutableSortedSet.class);
        REFERENCE_TYPES.add(SortedSetIterable.class);
        REFERENCE_TYPES.add(ImmutableSortedSet.class);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)BooleanBag.class, (JsonDeserializer<?>)MutableBagDeserializer.Boolean.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableBooleanBag.class, (JsonDeserializer<?>)MutableBagDeserializer.Boolean.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableBooleanBag.class, (JsonDeserializer<?>)ImmutableBagDeserializer.Boolean.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)BooleanIterable.class, (JsonDeserializer<?>)MutableListDeserializer.Boolean.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)BooleanList.class, (JsonDeserializer<?>)MutableListDeserializer.Boolean.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableBooleanList.class, (JsonDeserializer<?>)MutableListDeserializer.Boolean.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableBooleanCollection.class, (JsonDeserializer<?>)MutableListDeserializer.Boolean.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableBooleanList.class, (JsonDeserializer<?>)ImmutableListDeserializer.Boolean.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableBooleanCollection.class, (JsonDeserializer<?>)ImmutableListDeserializer.Boolean.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)BooleanSet.class, (JsonDeserializer<?>)MutableSetDeserializer.Boolean.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableBooleanSet.class, (JsonDeserializer<?>)MutableSetDeserializer.Boolean.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableBooleanSet.class, (JsonDeserializer<?>)ImmutableSetDeserializer.Boolean.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ByteBag.class, (JsonDeserializer<?>)MutableBagDeserializer.Byte.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableByteBag.class, (JsonDeserializer<?>)MutableBagDeserializer.Byte.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableByteBag.class, (JsonDeserializer<?>)ImmutableBagDeserializer.Byte.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ByteIterable.class, (JsonDeserializer<?>)MutableListDeserializer.Byte.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ByteList.class, (JsonDeserializer<?>)MutableListDeserializer.Byte.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableByteList.class, (JsonDeserializer<?>)MutableListDeserializer.Byte.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableByteCollection.class, (JsonDeserializer<?>)MutableListDeserializer.Byte.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableByteList.class, (JsonDeserializer<?>)ImmutableListDeserializer.Byte.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableByteCollection.class, (JsonDeserializer<?>)ImmutableListDeserializer.Byte.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ByteSet.class, (JsonDeserializer<?>)MutableSetDeserializer.Byte.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableByteSet.class, (JsonDeserializer<?>)MutableSetDeserializer.Byte.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableByteSet.class, (JsonDeserializer<?>)ImmutableSetDeserializer.Byte.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ShortBag.class, (JsonDeserializer<?>)MutableBagDeserializer.Short.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableShortBag.class, (JsonDeserializer<?>)MutableBagDeserializer.Short.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableShortBag.class, (JsonDeserializer<?>)ImmutableBagDeserializer.Short.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ShortIterable.class, (JsonDeserializer<?>)MutableListDeserializer.Short.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ShortList.class, (JsonDeserializer<?>)MutableListDeserializer.Short.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableShortList.class, (JsonDeserializer<?>)MutableListDeserializer.Short.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableShortCollection.class, (JsonDeserializer<?>)MutableListDeserializer.Short.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableShortList.class, (JsonDeserializer<?>)ImmutableListDeserializer.Short.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableShortCollection.class, (JsonDeserializer<?>)ImmutableListDeserializer.Short.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ShortSet.class, (JsonDeserializer<?>)MutableSetDeserializer.Short.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableShortSet.class, (JsonDeserializer<?>)MutableSetDeserializer.Short.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableShortSet.class, (JsonDeserializer<?>)ImmutableSetDeserializer.Short.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)CharBag.class, (JsonDeserializer<?>)MutableBagDeserializer.Char.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableCharBag.class, (JsonDeserializer<?>)MutableBagDeserializer.Char.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableCharBag.class, (JsonDeserializer<?>)ImmutableBagDeserializer.Char.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)CharIterable.class, (JsonDeserializer<?>)MutableListDeserializer.Char.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)CharList.class, (JsonDeserializer<?>)MutableListDeserializer.Char.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableCharList.class, (JsonDeserializer<?>)MutableListDeserializer.Char.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableCharCollection.class, (JsonDeserializer<?>)MutableListDeserializer.Char.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableCharList.class, (JsonDeserializer<?>)ImmutableListDeserializer.Char.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableCharCollection.class, (JsonDeserializer<?>)ImmutableListDeserializer.Char.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)CharSet.class, (JsonDeserializer<?>)MutableSetDeserializer.Char.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableCharSet.class, (JsonDeserializer<?>)MutableSetDeserializer.Char.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableCharSet.class, (JsonDeserializer<?>)ImmutableSetDeserializer.Char.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)IntBag.class, (JsonDeserializer<?>)MutableBagDeserializer.Int.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableIntBag.class, (JsonDeserializer<?>)MutableBagDeserializer.Int.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableIntBag.class, (JsonDeserializer<?>)ImmutableBagDeserializer.Int.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)IntIterable.class, (JsonDeserializer<?>)MutableListDeserializer.Int.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)IntList.class, (JsonDeserializer<?>)MutableListDeserializer.Int.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableIntList.class, (JsonDeserializer<?>)MutableListDeserializer.Int.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableIntCollection.class, (JsonDeserializer<?>)MutableListDeserializer.Int.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableIntList.class, (JsonDeserializer<?>)ImmutableListDeserializer.Int.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableIntCollection.class, (JsonDeserializer<?>)ImmutableListDeserializer.Int.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)IntSet.class, (JsonDeserializer<?>)MutableSetDeserializer.Int.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableIntSet.class, (JsonDeserializer<?>)MutableSetDeserializer.Int.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableIntSet.class, (JsonDeserializer<?>)ImmutableSetDeserializer.Int.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)FloatBag.class, (JsonDeserializer<?>)MutableBagDeserializer.Float.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableFloatBag.class, (JsonDeserializer<?>)MutableBagDeserializer.Float.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableFloatBag.class, (JsonDeserializer<?>)ImmutableBagDeserializer.Float.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)FloatIterable.class, (JsonDeserializer<?>)MutableListDeserializer.Float.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)FloatList.class, (JsonDeserializer<?>)MutableListDeserializer.Float.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableFloatList.class, (JsonDeserializer<?>)MutableListDeserializer.Float.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableFloatCollection.class, (JsonDeserializer<?>)MutableListDeserializer.Float.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableFloatList.class, (JsonDeserializer<?>)ImmutableListDeserializer.Float.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableFloatCollection.class, (JsonDeserializer<?>)ImmutableListDeserializer.Float.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)FloatSet.class, (JsonDeserializer<?>)MutableSetDeserializer.Float.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableFloatSet.class, (JsonDeserializer<?>)MutableSetDeserializer.Float.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableFloatSet.class, (JsonDeserializer<?>)ImmutableSetDeserializer.Float.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)LongBag.class, (JsonDeserializer<?>)MutableBagDeserializer.Long.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableLongBag.class, (JsonDeserializer<?>)MutableBagDeserializer.Long.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableLongBag.class, (JsonDeserializer<?>)ImmutableBagDeserializer.Long.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)LongIterable.class, (JsonDeserializer<?>)MutableListDeserializer.Long.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)LongList.class, (JsonDeserializer<?>)MutableListDeserializer.Long.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableLongList.class, (JsonDeserializer<?>)MutableListDeserializer.Long.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableLongCollection.class, (JsonDeserializer<?>)MutableListDeserializer.Long.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableLongList.class, (JsonDeserializer<?>)ImmutableListDeserializer.Long.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableLongCollection.class, (JsonDeserializer<?>)ImmutableListDeserializer.Long.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)LongSet.class, (JsonDeserializer<?>)MutableSetDeserializer.Long.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableLongSet.class, (JsonDeserializer<?>)MutableSetDeserializer.Long.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableLongSet.class, (JsonDeserializer<?>)ImmutableSetDeserializer.Long.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)DoubleBag.class, (JsonDeserializer<?>)MutableBagDeserializer.Double.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableDoubleBag.class, (JsonDeserializer<?>)MutableBagDeserializer.Double.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableDoubleBag.class, (JsonDeserializer<?>)ImmutableBagDeserializer.Double.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)DoubleIterable.class, (JsonDeserializer<?>)MutableListDeserializer.Double.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)DoubleList.class, (JsonDeserializer<?>)MutableListDeserializer.Double.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableDoubleList.class, (JsonDeserializer<?>)MutableListDeserializer.Double.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableDoubleCollection.class, (JsonDeserializer<?>)MutableListDeserializer.Double.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableDoubleList.class, (JsonDeserializer<?>)ImmutableListDeserializer.Double.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableDoubleCollection.class, (JsonDeserializer<?>)ImmutableListDeserializer.Double.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)DoubleSet.class, (JsonDeserializer<?>)MutableSetDeserializer.Double.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)MutableDoubleSet.class, (JsonDeserializer<?>)MutableSetDeserializer.Double.INSTANCE);
        PRIMITIVE_DESERIALIZERS.put((Class<PrimitiveIterable>)ImmutableDoubleSet.class, (JsonDeserializer<?>)ImmutableSetDeserializer.Double.INSTANCE);
    }
}

