/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.eclipsecollections.deser.map;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.datatype.eclipsecollections.deser.map.ValueHandler;
import java.io.IOException;

public class RefValueHandler
implements ValueHandler<RefValueHandler> {
    private final JavaType _valueType;
    private final JsonDeserializer<?> _valueDeserializer;
    private final TypeDeserializer _typeDeserializerForValue;

    public RefValueHandler(JavaType valueType, JsonDeserializer<?> _valueDeserializer, TypeDeserializer _typeDeserializerForValue) {
        if (valueType == null) {
            throw new IllegalArgumentException("valueType == null");
        }
        this._valueType = valueType;
        this._valueDeserializer = _valueDeserializer;
        this._typeDeserializerForValue = _typeDeserializerForValue;
    }

    @Override
    public RefValueHandler createContextualValue(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        TypeDeserializer typeDeser;
        JsonDeserializer deser = this._valueDeserializer == null ? ctxt.findContextualValueDeserializer(this._valueType, property) : this._valueDeserializer;
        TypeDeserializer typeDeserializer = typeDeser = this._typeDeserializerForValue == null ? ctxt.getFactory().findTypeDeserializer(ctxt.getConfig(), this._valueType) : this._typeDeserializerForValue;
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(property);
        }
        if (deser == this._valueDeserializer && typeDeser == this._typeDeserializerForValue) {
            return this;
        }
        return new RefValueHandler(this._valueType, deser, typeDeser);
    }

    public Object value(DeserializationContext ctx, JsonParser parser) throws IOException {
        if (parser.currentToken() == JsonToken.VALUE_NULL) {
            return this._valueDeserializer.getNullValue(ctx);
        }
        if (this._typeDeserializerForValue == null) {
            return this._valueDeserializer.deserialize(parser, ctx);
        }
        return this._valueDeserializer.deserializeWithType(parser, ctx, this._typeDeserializerForValue);
    }
}

