/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.eclipsecollections.deser.pair;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.ValueInstantiators;
import com.fasterxml.jackson.databind.introspect.AnnotationCollector;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.util.Annotations;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.Twin;
import org.eclipse.collections.api.tuple.primitive.BooleanBooleanPair;
import org.eclipse.collections.api.tuple.primitive.BooleanBytePair;
import org.eclipse.collections.api.tuple.primitive.BooleanCharPair;
import org.eclipse.collections.api.tuple.primitive.BooleanDoublePair;
import org.eclipse.collections.api.tuple.primitive.BooleanFloatPair;
import org.eclipse.collections.api.tuple.primitive.BooleanIntPair;
import org.eclipse.collections.api.tuple.primitive.BooleanLongPair;
import org.eclipse.collections.api.tuple.primitive.BooleanObjectPair;
import org.eclipse.collections.api.tuple.primitive.BooleanShortPair;
import org.eclipse.collections.api.tuple.primitive.ByteBooleanPair;
import org.eclipse.collections.api.tuple.primitive.ByteBytePair;
import org.eclipse.collections.api.tuple.primitive.ByteCharPair;
import org.eclipse.collections.api.tuple.primitive.ByteDoublePair;
import org.eclipse.collections.api.tuple.primitive.ByteFloatPair;
import org.eclipse.collections.api.tuple.primitive.ByteIntPair;
import org.eclipse.collections.api.tuple.primitive.ByteLongPair;
import org.eclipse.collections.api.tuple.primitive.ByteObjectPair;
import org.eclipse.collections.api.tuple.primitive.ByteShortPair;
import org.eclipse.collections.api.tuple.primitive.CharBooleanPair;
import org.eclipse.collections.api.tuple.primitive.CharBytePair;
import org.eclipse.collections.api.tuple.primitive.CharCharPair;
import org.eclipse.collections.api.tuple.primitive.CharDoublePair;
import org.eclipse.collections.api.tuple.primitive.CharFloatPair;
import org.eclipse.collections.api.tuple.primitive.CharIntPair;
import org.eclipse.collections.api.tuple.primitive.CharLongPair;
import org.eclipse.collections.api.tuple.primitive.CharObjectPair;
import org.eclipse.collections.api.tuple.primitive.CharShortPair;
import org.eclipse.collections.api.tuple.primitive.DoubleBooleanPair;
import org.eclipse.collections.api.tuple.primitive.DoubleBytePair;
import org.eclipse.collections.api.tuple.primitive.DoubleCharPair;
import org.eclipse.collections.api.tuple.primitive.DoubleDoublePair;
import org.eclipse.collections.api.tuple.primitive.DoubleFloatPair;
import org.eclipse.collections.api.tuple.primitive.DoubleIntPair;
import org.eclipse.collections.api.tuple.primitive.DoubleLongPair;
import org.eclipse.collections.api.tuple.primitive.DoubleObjectPair;
import org.eclipse.collections.api.tuple.primitive.DoubleShortPair;
import org.eclipse.collections.api.tuple.primitive.FloatBooleanPair;
import org.eclipse.collections.api.tuple.primitive.FloatBytePair;
import org.eclipse.collections.api.tuple.primitive.FloatCharPair;
import org.eclipse.collections.api.tuple.primitive.FloatDoublePair;
import org.eclipse.collections.api.tuple.primitive.FloatFloatPair;
import org.eclipse.collections.api.tuple.primitive.FloatIntPair;
import org.eclipse.collections.api.tuple.primitive.FloatLongPair;
import org.eclipse.collections.api.tuple.primitive.FloatObjectPair;
import org.eclipse.collections.api.tuple.primitive.FloatShortPair;
import org.eclipse.collections.api.tuple.primitive.IntBooleanPair;
import org.eclipse.collections.api.tuple.primitive.IntBytePair;
import org.eclipse.collections.api.tuple.primitive.IntCharPair;
import org.eclipse.collections.api.tuple.primitive.IntDoublePair;
import org.eclipse.collections.api.tuple.primitive.IntFloatPair;
import org.eclipse.collections.api.tuple.primitive.IntIntPair;
import org.eclipse.collections.api.tuple.primitive.IntLongPair;
import org.eclipse.collections.api.tuple.primitive.IntObjectPair;
import org.eclipse.collections.api.tuple.primitive.IntShortPair;
import org.eclipse.collections.api.tuple.primitive.LongBooleanPair;
import org.eclipse.collections.api.tuple.primitive.LongBytePair;
import org.eclipse.collections.api.tuple.primitive.LongCharPair;
import org.eclipse.collections.api.tuple.primitive.LongDoublePair;
import org.eclipse.collections.api.tuple.primitive.LongFloatPair;
import org.eclipse.collections.api.tuple.primitive.LongIntPair;
import org.eclipse.collections.api.tuple.primitive.LongLongPair;
import org.eclipse.collections.api.tuple.primitive.LongObjectPair;
import org.eclipse.collections.api.tuple.primitive.LongShortPair;
import org.eclipse.collections.api.tuple.primitive.ObjectBooleanPair;
import org.eclipse.collections.api.tuple.primitive.ObjectBytePair;
import org.eclipse.collections.api.tuple.primitive.ObjectCharPair;
import org.eclipse.collections.api.tuple.primitive.ObjectDoublePair;
import org.eclipse.collections.api.tuple.primitive.ObjectFloatPair;
import org.eclipse.collections.api.tuple.primitive.ObjectIntPair;
import org.eclipse.collections.api.tuple.primitive.ObjectLongPair;
import org.eclipse.collections.api.tuple.primitive.ObjectShortPair;
import org.eclipse.collections.api.tuple.primitive.ShortBooleanPair;
import org.eclipse.collections.api.tuple.primitive.ShortBytePair;
import org.eclipse.collections.api.tuple.primitive.ShortCharPair;
import org.eclipse.collections.api.tuple.primitive.ShortDoublePair;
import org.eclipse.collections.api.tuple.primitive.ShortFloatPair;
import org.eclipse.collections.api.tuple.primitive.ShortIntPair;
import org.eclipse.collections.api.tuple.primitive.ShortLongPair;
import org.eclipse.collections.api.tuple.primitive.ShortObjectPair;
import org.eclipse.collections.api.tuple.primitive.ShortShortPair;
import org.eclipse.collections.impl.tuple.Tuples;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public final class PairInstantiators
extends ValueInstantiators.Base {
    private static final Map<Class<?>, ValueInstantiator> PURE_PRIMITIVE_INSTANTIATORS = new HashMap();

    public ValueInstantiator findValueInstantiator(DeserializationConfig config, BeanDescription beanDesc, ValueInstantiator defaultInstantiator) {
        Class beanClass = beanDesc.getBeanClass();
        ValueInstantiator purePrimitive = PURE_PRIMITIVE_INSTANTIATORS.get(beanClass);
        if (purePrimitive != null) {
            return purePrimitive;
        }
        final JavaType beanType = beanDesc.getType();
        if (beanClass == BooleanObjectPair.class) {
            return PairInstantiators.primitiveObjectInstantiator(beanType, Boolean.TYPE, (one, two) -> PrimitiveTuples.pair((boolean)((Boolean)one), (Object)two));
        }
        if (beanClass == ByteObjectPair.class) {
            return PairInstantiators.primitiveObjectInstantiator(beanType, Byte.TYPE, (one, two) -> PrimitiveTuples.pair((byte)((Byte)one), (Object)two));
        }
        if (beanClass == ShortObjectPair.class) {
            return PairInstantiators.primitiveObjectInstantiator(beanType, Short.TYPE, (one, two) -> PrimitiveTuples.pair((short)((Short)one), (Object)two));
        }
        if (beanClass == CharObjectPair.class) {
            return PairInstantiators.primitiveObjectInstantiator(beanType, Character.TYPE, (one, two) -> PrimitiveTuples.pair((char)((Character)one).charValue(), (Object)two));
        }
        if (beanClass == IntObjectPair.class) {
            return PairInstantiators.primitiveObjectInstantiator(beanType, Integer.TYPE, (one, two) -> PrimitiveTuples.pair((int)((Integer)one), (Object)two));
        }
        if (beanClass == FloatObjectPair.class) {
            return PairInstantiators.primitiveObjectInstantiator(beanType, Float.TYPE, (one, two) -> PrimitiveTuples.pair((float)((Float)one).floatValue(), (Object)two));
        }
        if (beanClass == LongObjectPair.class) {
            return PairInstantiators.primitiveObjectInstantiator(beanType, Long.TYPE, (one, two) -> PrimitiveTuples.pair((long)((Long)one), (Object)two));
        }
        if (beanClass == DoubleObjectPair.class) {
            return PairInstantiators.primitiveObjectInstantiator(beanType, Double.TYPE, (one, two) -> PrimitiveTuples.pair((double)((Double)one), (Object)two));
        }
        if (beanClass == ObjectBooleanPair.class) {
            return PairInstantiators.objectPrimitiveInstantiator(beanType, Boolean.TYPE, (one, two) -> PrimitiveTuples.pair((Object)one, (boolean)((Boolean)two)));
        }
        if (beanClass == ObjectBytePair.class) {
            return PairInstantiators.objectPrimitiveInstantiator(beanType, Byte.TYPE, (one, two) -> PrimitiveTuples.pair((Object)one, (byte)((Byte)two)));
        }
        if (beanClass == ObjectShortPair.class) {
            return PairInstantiators.objectPrimitiveInstantiator(beanType, Short.TYPE, (one, two) -> PrimitiveTuples.pair((Object)one, (short)((Short)two)));
        }
        if (beanClass == ObjectCharPair.class) {
            return PairInstantiators.objectPrimitiveInstantiator(beanType, Character.TYPE, (one, two) -> PrimitiveTuples.pair((Object)one, (char)((Character)two).charValue()));
        }
        if (beanClass == ObjectIntPair.class) {
            return PairInstantiators.objectPrimitiveInstantiator(beanType, Integer.TYPE, (one, two) -> PrimitiveTuples.pair((Object)one, (int)((Integer)two)));
        }
        if (beanClass == ObjectFloatPair.class) {
            return PairInstantiators.objectPrimitiveInstantiator(beanType, Float.TYPE, (one, two) -> PrimitiveTuples.pair((Object)one, (float)((Float)two).floatValue()));
        }
        if (beanClass == ObjectLongPair.class) {
            return PairInstantiators.objectPrimitiveInstantiator(beanType, Long.TYPE, (one, two) -> PrimitiveTuples.pair((Object)one, (long)((Long)two)));
        }
        if (beanClass == ObjectDoublePair.class) {
            return PairInstantiators.objectPrimitiveInstantiator(beanType, Double.TYPE, (one, two) -> PrimitiveTuples.pair((Object)one, (double)((Double)two)));
        }
        if (beanClass == Pair.class) {
            return new ValueInstantiator.Base(beanType){

                public boolean canCreateFromObjectWith() {
                    return true;
                }

                public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig config) {
                    JavaType oneType = beanType.containedType(0);
                    JavaType twoType = beanType.containedType(1);
                    return PairInstantiators.makeProperties(config, oneType, twoType);
                }

                public Object createFromObjectWith(DeserializationContext ctxt, Object[] args) throws IOException {
                    return Tuples.pair((Object)args[0], (Object)args[1]);
                }
            };
        }
        if (beanClass == Twin.class) {
            return new ValueInstantiator.Base(beanType){

                public boolean canCreateFromObjectWith() {
                    return true;
                }

                public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig config) {
                    JavaType memberType = beanType.containedType(0);
                    return PairInstantiators.makeProperties(config, memberType, memberType);
                }

                public Object createFromObjectWith(DeserializationContext ctxt, Object[] args) throws IOException {
                    return Tuples.twin((Object)args[0], (Object)args[1]);
                }
            };
        }
        return defaultInstantiator;
    }

    private static <P> ValueInstantiator primitiveObjectInstantiator(final JavaType inputType, final Class<?> one, final BiFunction<Object, Object, P> factory) {
        return new ValueInstantiator.Base(inputType){

            public boolean canCreateFromObjectWith() {
                return true;
            }

            public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig config) {
                JavaType oneType = config.constructType(one);
                JavaType twoType = inputType.containedType(0);
                return PairInstantiators.makeProperties(config, oneType, twoType);
            }

            public Object createFromObjectWith(DeserializationContext ctxt, Object[] args) throws IOException {
                return factory.apply(args[0], args[1]);
            }
        };
    }

    private static <P> ValueInstantiator objectPrimitiveInstantiator(final JavaType inputType, final Class<?> two, final BiFunction<Object, Object, P> factory) {
        return new ValueInstantiator.Base(inputType){

            public boolean canCreateFromObjectWith() {
                return true;
            }

            public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig config) {
                JavaType oneType = inputType.containedType(0);
                JavaType twoType = config.constructType(two);
                return PairInstantiators.makeProperties(config, oneType, twoType);
            }

            public Object createFromObjectWith(DeserializationContext ctxt, Object[] args) throws IOException {
                return factory.apply(args[0], args[1]);
            }
        };
    }

    private static <P> void purePrimitiveInstantiator(Class<P> pairClass, final Class<?> one, final Class<?> two, final BiFunction<Object, Object, P> factory) {
        PURE_PRIMITIVE_INSTANTIATORS.put(pairClass, (ValueInstantiator)new ValueInstantiator.Base(pairClass){

            public boolean canCreateFromObjectWith() {
                return true;
            }

            public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig config) {
                JavaType oneType = config.constructType(one);
                JavaType twoType = config.constructType(two);
                return PairInstantiators.makeProperties(config, oneType, twoType);
            }

            public Object createFromObjectWith(DeserializationContext ctxt, Object[] args) throws IOException {
                return factory.apply(args[0], args[1]);
            }
        });
    }

    static SettableBeanProperty[] makeProperties(DeserializationConfig config, JavaType oneType, JavaType twoType) {
        try {
            return new SettableBeanProperty[]{CreatorProperty.construct((PropertyName)PropertyName.construct((String)"one"), (JavaType)oneType, null, (TypeDeserializer)config.findTypeDeserializer(oneType), (Annotations)AnnotationCollector.emptyAnnotations(), null, (int)0, null, (PropertyMetadata)PropertyMetadata.STD_REQUIRED), CreatorProperty.construct((PropertyName)PropertyName.construct((String)"two"), (JavaType)twoType, null, (TypeDeserializer)config.findTypeDeserializer(twoType), (Annotations)AnnotationCollector.emptyAnnotations(), null, (int)1, null, (PropertyMetadata)PropertyMetadata.STD_REQUIRED)};
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        PairInstantiators.purePrimitiveInstantiator(BooleanBooleanPair.class, Boolean.TYPE, Boolean.TYPE, (one, two) -> PrimitiveTuples.pair((boolean)((Boolean)one), (boolean)((Boolean)two)));
        PairInstantiators.purePrimitiveInstantiator(BooleanBytePair.class, Boolean.TYPE, Byte.TYPE, (one, two) -> PrimitiveTuples.pair((boolean)((Boolean)one), (byte)((Byte)two)));
        PairInstantiators.purePrimitiveInstantiator(BooleanShortPair.class, Boolean.TYPE, Short.TYPE, (one, two) -> PrimitiveTuples.pair((boolean)((Boolean)one), (short)((Short)two)));
        PairInstantiators.purePrimitiveInstantiator(BooleanCharPair.class, Boolean.TYPE, Character.TYPE, (one, two) -> PrimitiveTuples.pair((boolean)((Boolean)one), (char)((Character)two).charValue()));
        PairInstantiators.purePrimitiveInstantiator(BooleanIntPair.class, Boolean.TYPE, Integer.TYPE, (one, two) -> PrimitiveTuples.pair((boolean)((Boolean)one), (int)((Integer)two)));
        PairInstantiators.purePrimitiveInstantiator(BooleanFloatPair.class, Boolean.TYPE, Float.TYPE, (one, two) -> PrimitiveTuples.pair((boolean)((Boolean)one), (float)((Float)two).floatValue()));
        PairInstantiators.purePrimitiveInstantiator(BooleanLongPair.class, Boolean.TYPE, Long.TYPE, (one, two) -> PrimitiveTuples.pair((boolean)((Boolean)one), (long)((Long)two)));
        PairInstantiators.purePrimitiveInstantiator(BooleanDoublePair.class, Boolean.TYPE, Double.TYPE, (one, two) -> PrimitiveTuples.pair((boolean)((Boolean)one), (double)((Double)two)));
        PairInstantiators.purePrimitiveInstantiator(ByteBooleanPair.class, Byte.TYPE, Boolean.TYPE, (one, two) -> PrimitiveTuples.pair((byte)((Byte)one), (boolean)((Boolean)two)));
        PairInstantiators.purePrimitiveInstantiator(ByteBytePair.class, Byte.TYPE, Byte.TYPE, (one, two) -> PrimitiveTuples.pair((byte)((Byte)one), (byte)((Byte)two)));
        PairInstantiators.purePrimitiveInstantiator(ByteShortPair.class, Byte.TYPE, Short.TYPE, (one, two) -> PrimitiveTuples.pair((byte)((Byte)one), (short)((Short)two)));
        PairInstantiators.purePrimitiveInstantiator(ByteCharPair.class, Byte.TYPE, Character.TYPE, (one, two) -> PrimitiveTuples.pair((byte)((Byte)one), (char)((Character)two).charValue()));
        PairInstantiators.purePrimitiveInstantiator(ByteIntPair.class, Byte.TYPE, Integer.TYPE, (one, two) -> PrimitiveTuples.pair((byte)((Byte)one), (int)((Integer)two)));
        PairInstantiators.purePrimitiveInstantiator(ByteFloatPair.class, Byte.TYPE, Float.TYPE, (one, two) -> PrimitiveTuples.pair((byte)((Byte)one), (float)((Float)two).floatValue()));
        PairInstantiators.purePrimitiveInstantiator(ByteLongPair.class, Byte.TYPE, Long.TYPE, (one, two) -> PrimitiveTuples.pair((byte)((Byte)one), (long)((Long)two)));
        PairInstantiators.purePrimitiveInstantiator(ByteDoublePair.class, Byte.TYPE, Double.TYPE, (one, two) -> PrimitiveTuples.pair((byte)((Byte)one), (double)((Double)two)));
        PairInstantiators.purePrimitiveInstantiator(ShortBooleanPair.class, Short.TYPE, Boolean.TYPE, (one, two) -> PrimitiveTuples.pair((short)((Short)one), (boolean)((Boolean)two)));
        PairInstantiators.purePrimitiveInstantiator(ShortBytePair.class, Short.TYPE, Byte.TYPE, (one, two) -> PrimitiveTuples.pair((short)((Short)one), (byte)((Byte)two)));
        PairInstantiators.purePrimitiveInstantiator(ShortShortPair.class, Short.TYPE, Short.TYPE, (one, two) -> PrimitiveTuples.pair((short)((Short)one), (short)((Short)two)));
        PairInstantiators.purePrimitiveInstantiator(ShortCharPair.class, Short.TYPE, Character.TYPE, (one, two) -> PrimitiveTuples.pair((short)((Short)one), (char)((Character)two).charValue()));
        PairInstantiators.purePrimitiveInstantiator(ShortIntPair.class, Short.TYPE, Integer.TYPE, (one, two) -> PrimitiveTuples.pair((short)((Short)one), (int)((Integer)two)));
        PairInstantiators.purePrimitiveInstantiator(ShortFloatPair.class, Short.TYPE, Float.TYPE, (one, two) -> PrimitiveTuples.pair((short)((Short)one), (float)((Float)two).floatValue()));
        PairInstantiators.purePrimitiveInstantiator(ShortLongPair.class, Short.TYPE, Long.TYPE, (one, two) -> PrimitiveTuples.pair((short)((Short)one), (long)((Long)two)));
        PairInstantiators.purePrimitiveInstantiator(ShortDoublePair.class, Short.TYPE, Double.TYPE, (one, two) -> PrimitiveTuples.pair((short)((Short)one), (double)((Double)two)));
        PairInstantiators.purePrimitiveInstantiator(CharBooleanPair.class, Character.TYPE, Boolean.TYPE, (one, two) -> PrimitiveTuples.pair((char)((Character)one).charValue(), (boolean)((Boolean)two)));
        PairInstantiators.purePrimitiveInstantiator(CharBytePair.class, Character.TYPE, Byte.TYPE, (one, two) -> PrimitiveTuples.pair((char)((Character)one).charValue(), (byte)((Byte)two)));
        PairInstantiators.purePrimitiveInstantiator(CharShortPair.class, Character.TYPE, Short.TYPE, (one, two) -> PrimitiveTuples.pair((char)((Character)one).charValue(), (short)((Short)two)));
        PairInstantiators.purePrimitiveInstantiator(CharCharPair.class, Character.TYPE, Character.TYPE, (one, two) -> PrimitiveTuples.pair((char)((Character)one).charValue(), (char)((Character)two).charValue()));
        PairInstantiators.purePrimitiveInstantiator(CharIntPair.class, Character.TYPE, Integer.TYPE, (one, two) -> PrimitiveTuples.pair((char)((Character)one).charValue(), (int)((Integer)two)));
        PairInstantiators.purePrimitiveInstantiator(CharFloatPair.class, Character.TYPE, Float.TYPE, (one, two) -> PrimitiveTuples.pair((char)((Character)one).charValue(), (float)((Float)two).floatValue()));
        PairInstantiators.purePrimitiveInstantiator(CharLongPair.class, Character.TYPE, Long.TYPE, (one, two) -> PrimitiveTuples.pair((char)((Character)one).charValue(), (long)((Long)two)));
        PairInstantiators.purePrimitiveInstantiator(CharDoublePair.class, Character.TYPE, Double.TYPE, (one, two) -> PrimitiveTuples.pair((char)((Character)one).charValue(), (double)((Double)two)));
        PairInstantiators.purePrimitiveInstantiator(IntBooleanPair.class, Integer.TYPE, Boolean.TYPE, (one, two) -> PrimitiveTuples.pair((int)((Integer)one), (boolean)((Boolean)two)));
        PairInstantiators.purePrimitiveInstantiator(IntBytePair.class, Integer.TYPE, Byte.TYPE, (one, two) -> PrimitiveTuples.pair((int)((Integer)one), (byte)((Byte)two)));
        PairInstantiators.purePrimitiveInstantiator(IntShortPair.class, Integer.TYPE, Short.TYPE, (one, two) -> PrimitiveTuples.pair((int)((Integer)one), (short)((Short)two)));
        PairInstantiators.purePrimitiveInstantiator(IntCharPair.class, Integer.TYPE, Character.TYPE, (one, two) -> PrimitiveTuples.pair((int)((Integer)one), (char)((Character)two).charValue()));
        PairInstantiators.purePrimitiveInstantiator(IntIntPair.class, Integer.TYPE, Integer.TYPE, (one, two) -> PrimitiveTuples.pair((int)((Integer)one), (int)((Integer)two)));
        PairInstantiators.purePrimitiveInstantiator(IntFloatPair.class, Integer.TYPE, Float.TYPE, (one, two) -> PrimitiveTuples.pair((int)((Integer)one), (float)((Float)two).floatValue()));
        PairInstantiators.purePrimitiveInstantiator(IntLongPair.class, Integer.TYPE, Long.TYPE, (one, two) -> PrimitiveTuples.pair((int)((Integer)one), (long)((Long)two)));
        PairInstantiators.purePrimitiveInstantiator(IntDoublePair.class, Integer.TYPE, Double.TYPE, (one, two) -> PrimitiveTuples.pair((int)((Integer)one), (double)((Double)two)));
        PairInstantiators.purePrimitiveInstantiator(FloatBooleanPair.class, Float.TYPE, Boolean.TYPE, (one, two) -> PrimitiveTuples.pair((float)((Float)one).floatValue(), (boolean)((Boolean)two)));
        PairInstantiators.purePrimitiveInstantiator(FloatBytePair.class, Float.TYPE, Byte.TYPE, (one, two) -> PrimitiveTuples.pair((float)((Float)one).floatValue(), (byte)((Byte)two)));
        PairInstantiators.purePrimitiveInstantiator(FloatShortPair.class, Float.TYPE, Short.TYPE, (one, two) -> PrimitiveTuples.pair((float)((Float)one).floatValue(), (short)((Short)two)));
        PairInstantiators.purePrimitiveInstantiator(FloatCharPair.class, Float.TYPE, Character.TYPE, (one, two) -> PrimitiveTuples.pair((float)((Float)one).floatValue(), (char)((Character)two).charValue()));
        PairInstantiators.purePrimitiveInstantiator(FloatIntPair.class, Float.TYPE, Integer.TYPE, (one, two) -> PrimitiveTuples.pair((float)((Float)one).floatValue(), (int)((Integer)two)));
        PairInstantiators.purePrimitiveInstantiator(FloatFloatPair.class, Float.TYPE, Float.TYPE, (one, two) -> PrimitiveTuples.pair((float)((Float)one).floatValue(), (float)((Float)two).floatValue()));
        PairInstantiators.purePrimitiveInstantiator(FloatLongPair.class, Float.TYPE, Long.TYPE, (one, two) -> PrimitiveTuples.pair((float)((Float)one).floatValue(), (long)((Long)two)));
        PairInstantiators.purePrimitiveInstantiator(FloatDoublePair.class, Float.TYPE, Double.TYPE, (one, two) -> PrimitiveTuples.pair((float)((Float)one).floatValue(), (double)((Double)two)));
        PairInstantiators.purePrimitiveInstantiator(LongBooleanPair.class, Long.TYPE, Boolean.TYPE, (one, two) -> PrimitiveTuples.pair((long)((Long)one), (boolean)((Boolean)two)));
        PairInstantiators.purePrimitiveInstantiator(LongBytePair.class, Long.TYPE, Byte.TYPE, (one, two) -> PrimitiveTuples.pair((long)((Long)one), (byte)((Byte)two)));
        PairInstantiators.purePrimitiveInstantiator(LongShortPair.class, Long.TYPE, Short.TYPE, (one, two) -> PrimitiveTuples.pair((long)((Long)one), (short)((Short)two)));
        PairInstantiators.purePrimitiveInstantiator(LongCharPair.class, Long.TYPE, Character.TYPE, (one, two) -> PrimitiveTuples.pair((long)((Long)one), (char)((Character)two).charValue()));
        PairInstantiators.purePrimitiveInstantiator(LongIntPair.class, Long.TYPE, Integer.TYPE, (one, two) -> PrimitiveTuples.pair((long)((Long)one), (int)((Integer)two)));
        PairInstantiators.purePrimitiveInstantiator(LongFloatPair.class, Long.TYPE, Float.TYPE, (one, two) -> PrimitiveTuples.pair((long)((Long)one), (float)((Float)two).floatValue()));
        PairInstantiators.purePrimitiveInstantiator(LongLongPair.class, Long.TYPE, Long.TYPE, (one, two) -> PrimitiveTuples.pair((long)((Long)one), (long)((Long)two)));
        PairInstantiators.purePrimitiveInstantiator(LongDoublePair.class, Long.TYPE, Double.TYPE, (one, two) -> PrimitiveTuples.pair((long)((Long)one), (double)((Double)two)));
        PairInstantiators.purePrimitiveInstantiator(DoubleBooleanPair.class, Double.TYPE, Boolean.TYPE, (one, two) -> PrimitiveTuples.pair((double)((Double)one), (boolean)((Boolean)two)));
        PairInstantiators.purePrimitiveInstantiator(DoubleBytePair.class, Double.TYPE, Byte.TYPE, (one, two) -> PrimitiveTuples.pair((double)((Double)one), (byte)((Byte)two)));
        PairInstantiators.purePrimitiveInstantiator(DoubleShortPair.class, Double.TYPE, Short.TYPE, (one, two) -> PrimitiveTuples.pair((double)((Double)one), (short)((Short)two)));
        PairInstantiators.purePrimitiveInstantiator(DoubleCharPair.class, Double.TYPE, Character.TYPE, (one, two) -> PrimitiveTuples.pair((double)((Double)one), (char)((Character)two).charValue()));
        PairInstantiators.purePrimitiveInstantiator(DoubleIntPair.class, Double.TYPE, Integer.TYPE, (one, two) -> PrimitiveTuples.pair((double)((Double)one), (int)((Integer)two)));
        PairInstantiators.purePrimitiveInstantiator(DoubleFloatPair.class, Double.TYPE, Float.TYPE, (one, two) -> PrimitiveTuples.pair((double)((Double)one), (float)((Float)two).floatValue()));
        PairInstantiators.purePrimitiveInstantiator(DoubleLongPair.class, Double.TYPE, Long.TYPE, (one, two) -> PrimitiveTuples.pair((double)((Double)one), (long)((Long)two)));
        PairInstantiators.purePrimitiveInstantiator(DoubleDoublePair.class, Double.TYPE, Double.TYPE, (one, two) -> PrimitiveTuples.pair((double)((Double)one), (double)((Double)two)));
    }
}

