/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.eclipsecollections.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.iterator.CharIterator;

public final class CharIterableSerializer
extends StdSerializer<CharIterable> {
    public static final CharIterableSerializer INSTANCE = new CharIterableSerializer();

    protected CharIterableSerializer() {
        super(CharIterable.class);
    }

    public boolean isEmpty(SerializerProvider provider, CharIterable value) {
        return value.isEmpty();
    }

    public void serialize(CharIterable value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (provider.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS)) {
            gen.writeStartArray();
            this.writeContentsAsArray(value, gen);
            gen.writeEndArray();
        } else {
            char[] chars = value.toArray();
            gen.writeString(chars, 0, chars.length);
        }
    }

    public void serializeWithType(CharIterable value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef;
        g.setCurrentValue((Object)value);
        if (provider.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS)) {
            typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId((Object)value, JsonToken.START_ARRAY));
            this.writeContentsAsArray(value, g);
        } else {
            typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId((Object)value, JsonToken.VALUE_STRING));
            char[] chars = value.toArray();
            g.writeString(chars, 0, chars.length);
        }
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    private void writeContentsAsArray(CharIterable value, JsonGenerator g) throws IOException {
        char[] buf = new char[1];
        CharIterator iterator = value.charIterator();
        while (iterator.hasNext()) {
            buf[0] = iterator.next();
            g.writeString(buf, 0, 1);
        }
    }
}

