/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.eclipsecollections.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.eclipsecollections.ser.PrimitiveIterableSerializer;
import java.io.IOException;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.iterator.FloatIterator;

public final class FloatIterableSerializer
extends PrimitiveIterableSerializer<FloatIterable> {
    private static final JavaType ELEMENT_TYPE = TypeFactory.defaultInstance().constructType(Float.TYPE);

    public FloatIterableSerializer(BeanProperty property, Boolean unwrapSingle) {
        super(FloatIterable.class, ELEMENT_TYPE, property, unwrapSingle);
    }

    protected FloatIterableSerializer withResolved(BeanProperty property, Boolean unwrapSingle) {
        return new FloatIterableSerializer(property, unwrapSingle);
    }

    @Override
    protected void serializeContents(FloatIterable value, JsonGenerator gen) throws IOException {
        FloatIterator iterator = value.floatIterator();
        while (iterator.hasNext()) {
            gen.writeNumber(iterator.next());
        }
    }
}

