/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.eclipsecollections.ser.map;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.datatype.eclipsecollections.ser.map.PrimitiveMapSerializer;
import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.PrimitiveIterable;
import org.eclipse.collections.api.block.procedure.primitive.ObjectBooleanProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectCharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectDoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectFloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectLongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectShortProcedure;
import org.eclipse.collections.api.map.primitive.ObjectBooleanMap;
import org.eclipse.collections.api.map.primitive.ObjectByteMap;
import org.eclipse.collections.api.map.primitive.ObjectCharMap;
import org.eclipse.collections.api.map.primitive.ObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.ObjectFloatMap;
import org.eclipse.collections.api.map.primitive.ObjectIntMap;
import org.eclipse.collections.api.map.primitive.ObjectLongMap;
import org.eclipse.collections.api.map.primitive.ObjectShortMap;

public abstract class RefPrimitiveMapSerializer<T extends PrimitiveIterable, K>
extends PrimitiveMapSerializer<T>
implements ContextualSerializer {
    protected final JavaType _type;
    protected final BeanProperty _property;
    protected final JsonSerializer<Object> _keySerializer;

    private RefPrimitiveMapSerializer(JavaType type, BeanProperty property, JsonSerializer<Object> keySerializer) {
        super(type);
        this._type = type;
        this._property = property;
        this._keySerializer = keySerializer;
    }

    protected abstract RefPrimitiveMapSerializer<T, K> withResolved(BeanProperty var1, JsonSerializer<Object> var2);

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JsonSerializer ks = this._keySerializer == null ? prov.findKeySerializer(this._type.containedTypeOrUnknown(0), property) : this._keySerializer;
        return this.withResolved(property, (JsonSerializer<Object>)ks);
    }

    protected void _serializeKey(K key, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (key == null) {
            provider.findNullKeySerializer(this._type.getKeyType(), this._property).serialize(null, gen, provider);
        } else {
            this._keySerializer.serialize(key, gen, provider);
        }
    }

    public static final class Double<K>
    extends RefPrimitiveMapSerializer<ObjectDoubleMap<K>, K> {
        public Double(JavaType type, BeanProperty property, JsonSerializer<Object> keySerializer) {
            super(type, property, keySerializer);
        }

        @Override
        protected RefPrimitiveMapSerializer<ObjectDoubleMap<K>, K> withResolved(BeanProperty property, JsonSerializer<Object> keySerializer) {
            return new Double<K>(this._type, property, keySerializer);
        }

        @Override
        protected void serializeEntries(ObjectDoubleMap<K> value, JsonGenerator gen, SerializerProvider serializers) {
            value.forEachKeyValue((ObjectDoubleProcedure & Serializable)(k, v) -> {
                try {
                    this._serializeKey(k, gen, serializers);
                    gen.writeNumber(v);
                }
                catch (IOException e) {
                    Double.rethrowUnchecked(e);
                }
            });
        }
    }

    public static final class Long<K>
    extends RefPrimitiveMapSerializer<ObjectLongMap<K>, K> {
        public Long(JavaType type, BeanProperty property, JsonSerializer<Object> keySerializer) {
            super(type, property, keySerializer);
        }

        @Override
        protected RefPrimitiveMapSerializer<ObjectLongMap<K>, K> withResolved(BeanProperty property, JsonSerializer<Object> keySerializer) {
            return new Long<K>(this._type, property, keySerializer);
        }

        @Override
        protected void serializeEntries(ObjectLongMap<K> value, JsonGenerator gen, SerializerProvider serializers) {
            value.forEachKeyValue((ObjectLongProcedure & Serializable)(k, v) -> {
                try {
                    this._serializeKey(k, gen, serializers);
                    gen.writeNumber(v);
                }
                catch (IOException e) {
                    Long.rethrowUnchecked(e);
                }
            });
        }
    }

    public static final class Float<K>
    extends RefPrimitiveMapSerializer<ObjectFloatMap<K>, K> {
        public Float(JavaType type, BeanProperty property, JsonSerializer<Object> keySerializer) {
            super(type, property, keySerializer);
        }

        @Override
        protected RefPrimitiveMapSerializer<ObjectFloatMap<K>, K> withResolved(BeanProperty property, JsonSerializer<Object> keySerializer) {
            return new Float<K>(this._type, property, keySerializer);
        }

        @Override
        protected void serializeEntries(ObjectFloatMap<K> value, JsonGenerator gen, SerializerProvider serializers) {
            value.forEachKeyValue((ObjectFloatProcedure & Serializable)(k, v) -> {
                try {
                    this._serializeKey(k, gen, serializers);
                    gen.writeNumber(v);
                }
                catch (IOException e) {
                    Float.rethrowUnchecked(e);
                }
            });
        }
    }

    public static final class Int<K>
    extends RefPrimitiveMapSerializer<ObjectIntMap<K>, K> {
        public Int(JavaType type, BeanProperty property, JsonSerializer<Object> keySerializer) {
            super(type, property, keySerializer);
        }

        @Override
        protected RefPrimitiveMapSerializer<ObjectIntMap<K>, K> withResolved(BeanProperty property, JsonSerializer<Object> keySerializer) {
            return new Int<K>(this._type, property, keySerializer);
        }

        @Override
        protected void serializeEntries(ObjectIntMap<K> value, JsonGenerator gen, SerializerProvider serializers) {
            value.forEachKeyValue((ObjectIntProcedure & Serializable)(k, v) -> {
                try {
                    this._serializeKey(k, gen, serializers);
                    gen.writeNumber(v);
                }
                catch (IOException e) {
                    Int.rethrowUnchecked(e);
                }
            });
        }
    }

    public static final class Char<K>
    extends RefPrimitiveMapSerializer<ObjectCharMap<K>, K> {
        public Char(JavaType type, BeanProperty property, JsonSerializer<Object> keySerializer) {
            super(type, property, keySerializer);
        }

        @Override
        protected RefPrimitiveMapSerializer<ObjectCharMap<K>, K> withResolved(BeanProperty property, JsonSerializer<Object> keySerializer) {
            return new Char<K>(this._type, property, keySerializer);
        }

        @Override
        protected void serializeEntries(ObjectCharMap<K> value, JsonGenerator gen, SerializerProvider serializers) {
            value.forEachKeyValue((ObjectCharProcedure & Serializable)(k, v) -> {
                try {
                    this._serializeKey(k, gen, serializers);
                    gen.writeString(new char[]{v}, 0, 1);
                }
                catch (IOException e) {
                    Char.rethrowUnchecked(e);
                }
            });
        }
    }

    public static final class Short<K>
    extends RefPrimitiveMapSerializer<ObjectShortMap<K>, K> {
        public Short(JavaType type, BeanProperty property, JsonSerializer<Object> keySerializer) {
            super(type, property, keySerializer);
        }

        @Override
        protected RefPrimitiveMapSerializer<ObjectShortMap<K>, K> withResolved(BeanProperty property, JsonSerializer<Object> keySerializer) {
            return new Short<K>(this._type, property, keySerializer);
        }

        @Override
        protected void serializeEntries(ObjectShortMap<K> value, JsonGenerator gen, SerializerProvider serializers) {
            value.forEachKeyValue((ObjectShortProcedure & Serializable)(k, v) -> {
                try {
                    this._serializeKey(k, gen, serializers);
                    gen.writeNumber(v);
                }
                catch (IOException e) {
                    Short.rethrowUnchecked(e);
                }
            });
        }
    }

    public static final class Byte<K>
    extends RefPrimitiveMapSerializer<ObjectByteMap<K>, K> {
        public Byte(JavaType type, BeanProperty property, JsonSerializer<Object> keySerializer) {
            super(type, property, keySerializer);
        }

        @Override
        protected RefPrimitiveMapSerializer<ObjectByteMap<K>, K> withResolved(BeanProperty property, JsonSerializer<Object> keySerializer) {
            return new Byte<K>(this._type, property, keySerializer);
        }

        @Override
        protected void serializeEntries(ObjectByteMap<K> value, JsonGenerator gen, SerializerProvider serializers) {
            value.forEachKeyValue((ObjectByteProcedure & Serializable)(k, v) -> {
                try {
                    this._serializeKey(k, gen, serializers);
                    gen.writeNumber((short)v);
                }
                catch (IOException e) {
                    Byte.rethrowUnchecked(e);
                }
            });
        }
    }

    public static final class Boolean<K>
    extends RefPrimitiveMapSerializer<ObjectBooleanMap<K>, K> {
        public Boolean(JavaType type, BeanProperty property, JsonSerializer<Object> keySerializer) {
            super(type, property, keySerializer);
        }

        @Override
        protected RefPrimitiveMapSerializer<ObjectBooleanMap<K>, K> withResolved(BeanProperty property, JsonSerializer<Object> keySerializer) {
            return new Boolean<K>(this._type, property, keySerializer);
        }

        @Override
        protected void serializeEntries(ObjectBooleanMap<K> value, JsonGenerator gen, SerializerProvider serializers) {
            value.forEachKeyValue((ObjectBooleanProcedure & Serializable)(k, v) -> {
                try {
                    this._serializeKey(k, gen, serializers);
                    gen.writeBoolean(v);
                }
                catch (IOException e) {
                    Boolean.rethrowUnchecked(e);
                }
            });
        }
    }
}

