/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.eclipsecollections.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;

public abstract class BaseCollectionDeserializer<T, Intermediate>
extends StdDeserializer<T> {
    private static final long serialVersionUID = 2L;

    protected BaseCollectionDeserializer(Class<? super T> cls) {
        super(cls);
    }

    protected BaseCollectionDeserializer(JavaType type) {
        super(type);
    }

    public LogicalType logicalType() {
        return LogicalType.Collection;
    }

    protected abstract Intermediate createIntermediate();

    protected abstract void add(Intermediate var1, JsonParser var2, DeserializationContext var3) throws IOException;

    protected abstract T finish(Intermediate var1);

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromArray(p, ctxt);
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.isExpectedStartArrayToken()) {
            return this._deserializeContents(p, ctxt);
        }
        if (ctxt.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            return this._deserializeFromSingleValue(p, ctxt);
        }
        return (T)ctxt.handleUnexpectedToken(this.handledType(), p);
    }

    protected T _deserializeContents(JsonParser p, DeserializationContext ctxt) throws IOException {
        Intermediate collection = this.createIntermediate();
        while (p.nextToken() != JsonToken.END_ARRAY) {
            this.add(collection, p, ctxt);
        }
        return this.finish(collection);
    }

    protected T _deserializeFromSingleValue(JsonParser p, DeserializationContext ctxt) throws IOException {
        Intermediate intermediate = this.createIntermediate();
        this.add(intermediate, p, ctxt);
        return this.finish(intermediate);
    }

    public static abstract class Ref<T, Intermediate extends MutableCollection<Object>>
    extends BaseCollectionDeserializer<T, Intermediate>
    implements ContextualDeserializer {
        protected final JavaType _elementType;
        protected final JsonDeserializer<?> _valueDeserializer;
        protected final TypeDeserializer _typeDeserializerForValue;

        protected Ref(Class<? super T> containerType, JavaType elementType, TypeDeserializer typeDeserializer, JsonDeserializer<?> deserializer) {
            super(containerType);
            this._elementType = elementType;
            this._typeDeserializerForValue = typeDeserializer;
            this._valueDeserializer = deserializer;
        }

        protected abstract Ref<?, ?> withResolved(TypeDeserializer var1, JsonDeserializer<?> var2);

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            JsonDeserializer deser = this._valueDeserializer;
            TypeDeserializer typeDeser = this._typeDeserializerForValue;
            if (deser == null) {
                deser = ctxt.findContextualValueDeserializer(this._elementType, property);
            }
            if (typeDeser != null) {
                typeDeser = typeDeser.forProperty(property);
            }
            if (deser == this._valueDeserializer && typeDeser == this._typeDeserializerForValue) {
                return this;
            }
            return this.withResolved(typeDeser, deser);
        }

        @Override
        protected void add(Intermediate intermediate, JsonParser parser, DeserializationContext ctx) throws IOException {
            Object value = parser.currentToken() == JsonToken.VALUE_NULL ? null : (this._typeDeserializerForValue == null ? this._valueDeserializer.deserialize(parser, ctx) : this._valueDeserializer.deserializeWithType(parser, ctx, this._typeDeserializerForValue));
            intermediate.add(value);
        }
    }

    public static abstract class Double<T extends DoubleIterable, Intermediate extends MutableDoubleCollection>
    extends BaseCollectionDeserializer<T, Intermediate> {
        protected Double(Class<? super T> cls) {
            super(cls);
        }

        @Override
        protected void add(Intermediate intermediate, JsonParser parser, DeserializationContext ctx) throws IOException {
            intermediate.add(parser.getDoubleValue());
        }
    }

    public static abstract class Long<T extends LongIterable, Intermediate extends MutableLongCollection>
    extends BaseCollectionDeserializer<T, Intermediate> {
        protected Long(Class<? super T> cls) {
            super(cls);
        }

        @Override
        protected void add(Intermediate intermediate, JsonParser parser, DeserializationContext ctx) throws IOException {
            intermediate.add(parser.getLongValue());
        }
    }

    public static abstract class Float<T extends FloatIterable, Intermediate extends MutableFloatCollection>
    extends BaseCollectionDeserializer<T, Intermediate> {
        protected Float(Class<? super T> cls) {
            super(cls);
        }

        @Override
        protected void add(Intermediate intermediate, JsonParser parser, DeserializationContext ctx) throws IOException {
            intermediate.add(parser.getFloatValue());
        }
    }

    public static abstract class Int<T extends IntIterable, Intermediate extends MutableIntCollection>
    extends BaseCollectionDeserializer<T, Intermediate> {
        protected Int(Class<? super T> cls) {
            super(cls);
        }

        @Override
        protected void add(Intermediate intermediate, JsonParser parser, DeserializationContext ctx) throws IOException {
            intermediate.add(parser.getIntValue());
        }
    }

    public static abstract class Char<T extends CharIterable, Intermediate extends MutableCharCollection>
    extends StdDeserializer<T> {
        private static final int BATCH_COPY_SIZE = 4096;

        protected Char(Class<? super T> cls) {
            super(cls);
        }

        protected abstract Intermediate createIntermediate();

        protected abstract T finish(Intermediate var1);

        public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
            return typeDeserializer.deserializeTypedFromScalar(p, ctxt);
        }

        public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Intermediate intermediate = this.createIntermediate();
            if (p.isExpectedStartArrayToken()) {
                JsonToken t;
                while ((t = p.nextToken()) != JsonToken.END_ARRAY) {
                    String str;
                    if (t == JsonToken.VALUE_STRING) {
                        str = p.getText();
                    } else {
                        CharSequence cs = (CharSequence)ctxt.handleUnexpectedToken(Character.TYPE, p);
                        str = cs.toString();
                    }
                    if (str.length() != 1) {
                        ctxt.reportInputMismatch((JsonDeserializer)this, "Cannot convert a JSON String of length %d into a char element of char array", new Object[]{str.length()});
                    }
                    intermediate.add(str.charAt(0));
                }
                return this.finish(intermediate);
            }
            char[] chars = p.getTextCharacters();
            if (p.getTextOffset() == 0 && p.getTextLength() == chars.length) {
                intermediate.addAll(chars);
            } else {
                int i = 0;
                if (p.getTextLength() - i >= 4096) {
                    char[] buf = new char[4096];
                    do {
                        System.arraycopy(chars, p.getTextOffset() + i, buf, 0, 4096);
                        intermediate.addAll(buf);
                    } while (p.getTextLength() - (i += 4096) >= 4096);
                }
                if (p.getTextLength() > i) {
                    char[] tail = Arrays.copyOfRange(chars, p.getTextOffset() + i, p.getTextOffset() + p.getTextLength());
                    intermediate.addAll(tail);
                }
            }
            return this.finish(intermediate);
        }
    }

    public static abstract class Short<T extends ShortIterable, Intermediate extends MutableShortCollection>
    extends BaseCollectionDeserializer<T, Intermediate> {
        protected Short(Class<? super T> cls) {
            super(cls);
        }

        @Override
        protected void add(Intermediate intermediate, JsonParser parser, DeserializationContext ctx) throws IOException {
            intermediate.add(parser.getShortValue());
        }
    }

    public static abstract class Byte<T extends ByteIterable, Intermediate extends MutableByteCollection>
    extends BaseCollectionDeserializer<T, Intermediate> {
        protected Byte(Class<? super T> cls) {
            super(cls);
        }

        @Override
        public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            if (p.currentToken() == JsonToken.VALUE_STRING || p.currentToken() == JsonToken.VALUE_EMBEDDED_OBJECT) {
                byte[] binaryValue = p.getBinaryValue();
                MutableByteCollection intermediate = (MutableByteCollection)this.createIntermediate();
                intermediate.addAll(binaryValue);
                return (T)((ByteIterable)this.finish(intermediate));
            }
            return (T)((ByteIterable)super.deserialize(p, ctxt));
        }

        @Override
        protected void add(Intermediate intermediate, JsonParser parser, DeserializationContext ctx) throws IOException {
            intermediate.add(parser.getByteValue());
        }
    }

    public static abstract class Boolean<T extends BooleanIterable, Intermediate extends MutableBooleanCollection>
    extends BaseCollectionDeserializer<T, Intermediate> {
        protected Boolean(Class<? super T> cls) {
            super(cls);
        }

        @Override
        protected void add(Intermediate intermediate, JsonParser parser, DeserializationContext ctx) throws IOException {
            intermediate.add(parser.getBooleanValue());
        }
    }
}

