/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.eclipsecollections.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import java.io.IOException;
import org.eclipse.collections.api.PrimitiveIterable;

public abstract class PrimitiveIterableSerializer<C extends PrimitiveIterable>
extends ContainerSerializer<C> {
    protected final JavaType _elementType;
    protected final BeanProperty _property;
    protected final Boolean _unwrapSingle;

    public PrimitiveIterableSerializer(Class<C> type, JavaType elementType, BeanProperty property, Boolean unwrapSingle) {
        super(type);
        this._elementType = elementType;
        this._property = property;
        this._unwrapSingle = unwrapSingle;
    }

    protected abstract PrimitiveIterableSerializer<C> withResolved(BeanProperty var1, Boolean var2);

    public boolean isEmpty(SerializerProvider prov, C value) {
        return value.isEmpty();
    }

    public JavaType getContentType() {
        return this._elementType;
    }

    public JsonSerializer<?> getContentSerializer() {
        return null;
    }

    protected ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        return this;
    }

    public boolean hasSingleElement(C value) {
        if (value != null) {
            return value.size() == 1;
        }
        return false;
    }

    public final void serialize(C value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if ((this._unwrapSingle == null && provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || Boolean.TRUE.equals(this._unwrapSingle)) && this.hasSingleElement(value)) {
            this.serializeContents(value, gen);
            return;
        }
        gen.writeStartArray();
        this.serializeContents(value, gen);
        gen.writeEndArray();
    }

    public void serializeWithType(C value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        g.setCurrentValue(value);
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.START_ARRAY));
        this.serializeContents(value, g);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    protected abstract void serializeContents(C var1, JsonGenerator var2) throws IOException;
}

