/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.eclipsecollections.ser.map;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.datatype.eclipsecollections.ser.map.PrimitiveMapSerializer;
import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.block.procedure.primitive.ByteObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortObjectProcedure;
import org.eclipse.collections.api.map.primitive.ByteObjectMap;
import org.eclipse.collections.api.map.primitive.CharObjectMap;
import org.eclipse.collections.api.map.primitive.DoubleObjectMap;
import org.eclipse.collections.api.map.primitive.FloatObjectMap;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.api.map.primitive.PrimitiveObjectMap;
import org.eclipse.collections.api.map.primitive.ShortObjectMap;

public abstract class PrimitiveRefMapSerializer<T extends PrimitiveObjectMap<V>, V>
extends PrimitiveMapSerializer<T>
implements ContextualSerializer {
    protected final JavaType _type;
    protected final BeanProperty _property;
    protected final TypeSerializer _valueTypeSerializer;
    protected final JsonSerializer<Object> _valueSerializer;
    protected PropertySerializerMap _dynamicValueSerializers = PropertySerializerMap.emptyForProperties();

    public PrimitiveRefMapSerializer(JavaType type, BeanProperty property, TypeSerializer vts, JsonSerializer<Object> valueSerializer) {
        super(type);
        this._type = type;
        this._property = property;
        this._valueTypeSerializer = vts;
        this._valueSerializer = valueSerializer;
    }

    protected abstract PrimitiveRefMapSerializer<T, V> withResolved(TypeSerializer var1, BeanProperty var2, JsonSerializer<Object> var3);

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JsonSerializer vs;
        TypeSerializer vts;
        JavaType containedType = this._type.containedTypeOrUnknown(0);
        TypeSerializer typeSerializer = vts = this._valueTypeSerializer == null ? prov.findTypeSerializer(containedType) : this._valueTypeSerializer;
        if (vts != null) {
            vts = vts.forProperty(property);
        }
        JsonSerializer jsonSerializer = vs = this._valueSerializer == null && containedType.useStaticType() ? prov.findValueSerializer(containedType) : this._valueSerializer;
        if (vts == this._valueTypeSerializer && vs == this._valueSerializer) {
            return this;
        }
        return this.withResolved(vts, property, (JsonSerializer<Object>)vs);
    }

    protected void _serializeValue(V value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        Class<?> cc;
        JsonSerializer<Object> valueSer = this._valueSerializer;
        if (valueSer == null && (valueSer = this._dynamicValueSerializers.serializerFor(cc = value.getClass())) == null) {
            valueSer = this._findAndAddDynamic(this._dynamicValueSerializers, serializers.constructType(cc), serializers);
        }
        if (this._valueTypeSerializer == null) {
            valueSer.serialize(value, gen, serializers);
        } else {
            valueSer.serializeWithType(value, gen, serializers, this._valueTypeSerializer);
        }
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap map, JavaType type, SerializerProvider provider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSecondarySerializer(type, provider, this._property);
        if (map != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }

    public static class Double<V>
    extends PrimitiveRefMapSerializer<DoubleObjectMap<V>, V> {
        public Double(JavaType type, BeanProperty property, TypeSerializer vts, JsonSerializer<Object> valueSerializer) {
            super(type, property, vts, valueSerializer);
        }

        @Override
        protected void serializeEntries(DoubleObjectMap<V> value, JsonGenerator gen, SerializerProvider serializers) {
            value.forEachKeyValue((DoubleObjectProcedure & Serializable)(k, v) -> {
                try {
                    gen.writeFieldName(String.valueOf(k));
                    this._serializeValue(v, gen, serializers);
                }
                catch (IOException e) {
                    Double.rethrowUnchecked(e);
                }
            });
        }

        @Override
        protected PrimitiveRefMapSerializer<DoubleObjectMap<V>, V> withResolved(TypeSerializer vts, BeanProperty property, JsonSerializer<Object> valueSerializer) {
            return new Double<V>(this._type, property, vts, valueSerializer);
        }
    }

    public static class Long<V>
    extends PrimitiveRefMapSerializer<LongObjectMap<V>, V> {
        public Long(JavaType type, BeanProperty property, TypeSerializer vts, JsonSerializer<Object> valueSerializer) {
            super(type, property, vts, valueSerializer);
        }

        @Override
        protected void serializeEntries(LongObjectMap<V> value, JsonGenerator gen, SerializerProvider serializers) {
            value.forEachKeyValue((LongObjectProcedure & Serializable)(k, v) -> {
                try {
                    gen.writeFieldName(String.valueOf(k));
                    this._serializeValue(v, gen, serializers);
                }
                catch (IOException e) {
                    Long.rethrowUnchecked(e);
                }
            });
        }

        @Override
        protected PrimitiveRefMapSerializer<LongObjectMap<V>, V> withResolved(TypeSerializer vts, BeanProperty property, JsonSerializer<Object> valueSerializer) {
            return new Long<V>(this._type, property, vts, valueSerializer);
        }
    }

    public static class Float<V>
    extends PrimitiveRefMapSerializer<FloatObjectMap<V>, V> {
        public Float(JavaType type, BeanProperty property, TypeSerializer vts, JsonSerializer<Object> valueSerializer) {
            super(type, property, vts, valueSerializer);
        }

        @Override
        protected void serializeEntries(FloatObjectMap<V> value, JsonGenerator gen, SerializerProvider serializers) {
            value.forEachKeyValue((FloatObjectProcedure & Serializable)(k, v) -> {
                try {
                    gen.writeFieldName(String.valueOf(k));
                    this._serializeValue(v, gen, serializers);
                }
                catch (IOException e) {
                    Float.rethrowUnchecked(e);
                }
            });
        }

        @Override
        protected PrimitiveRefMapSerializer<FloatObjectMap<V>, V> withResolved(TypeSerializer vts, BeanProperty property, JsonSerializer<Object> valueSerializer) {
            return new Float<V>(this._type, property, vts, valueSerializer);
        }
    }

    public static class Int<V>
    extends PrimitiveRefMapSerializer<IntObjectMap<V>, V> {
        public Int(JavaType type, BeanProperty property, TypeSerializer vts, JsonSerializer<Object> valueSerializer) {
            super(type, property, vts, valueSerializer);
        }

        @Override
        protected void serializeEntries(IntObjectMap<V> value, JsonGenerator gen, SerializerProvider serializers) {
            value.forEachKeyValue((IntObjectProcedure & Serializable)(k, v) -> {
                try {
                    gen.writeFieldName(String.valueOf(k));
                    this._serializeValue(v, gen, serializers);
                }
                catch (IOException e) {
                    Int.rethrowUnchecked(e);
                }
            });
        }

        @Override
        protected PrimitiveRefMapSerializer<IntObjectMap<V>, V> withResolved(TypeSerializer vts, BeanProperty property, JsonSerializer<Object> valueSerializer) {
            return new Int<V>(this._type, property, vts, valueSerializer);
        }
    }

    public static class Char<V>
    extends PrimitiveRefMapSerializer<CharObjectMap<V>, V> {
        public Char(JavaType type, BeanProperty property, TypeSerializer vts, JsonSerializer<Object> valueSerializer) {
            super(type, property, vts, valueSerializer);
        }

        @Override
        protected void serializeEntries(CharObjectMap<V> value, JsonGenerator gen, SerializerProvider serializers) {
            value.forEachKeyValue((CharObjectProcedure & Serializable)(k, v) -> {
                try {
                    gen.writeFieldName(String.valueOf(k));
                    this._serializeValue(v, gen, serializers);
                }
                catch (IOException e) {
                    Char.rethrowUnchecked(e);
                }
            });
        }

        @Override
        protected PrimitiveRefMapSerializer<CharObjectMap<V>, V> withResolved(TypeSerializer vts, BeanProperty property, JsonSerializer<Object> valueSerializer) {
            return new Char<V>(this._type, property, vts, valueSerializer);
        }
    }

    public static class Short<V>
    extends PrimitiveRefMapSerializer<ShortObjectMap<V>, V> {
        public Short(JavaType type, BeanProperty property, TypeSerializer vts, JsonSerializer<Object> valueSerializer) {
            super(type, property, vts, valueSerializer);
        }

        @Override
        protected void serializeEntries(ShortObjectMap<V> value, JsonGenerator gen, SerializerProvider serializers) {
            value.forEachKeyValue((ShortObjectProcedure & Serializable)(k, v) -> {
                try {
                    gen.writeFieldName(String.valueOf(k));
                    this._serializeValue(v, gen, serializers);
                }
                catch (IOException e) {
                    Short.rethrowUnchecked(e);
                }
            });
        }

        @Override
        protected PrimitiveRefMapSerializer<ShortObjectMap<V>, V> withResolved(TypeSerializer vts, BeanProperty property, JsonSerializer<Object> valueSerializer) {
            return new Short<V>(this._type, property, vts, valueSerializer);
        }
    }

    public static class Byte<V>
    extends PrimitiveRefMapSerializer<ByteObjectMap<V>, V> {
        public Byte(JavaType type, BeanProperty property, TypeSerializer vts, JsonSerializer<Object> valueSerializer) {
            super(type, property, vts, valueSerializer);
        }

        @Override
        protected void serializeEntries(ByteObjectMap<V> value, JsonGenerator gen, SerializerProvider serializers) {
            value.forEachKeyValue((ByteObjectProcedure & Serializable)(k, v) -> {
                try {
                    gen.writeFieldName(String.valueOf(k));
                    this._serializeValue(v, gen, serializers);
                }
                catch (IOException e) {
                    Byte.rethrowUnchecked(e);
                }
            });
        }

        @Override
        protected PrimitiveRefMapSerializer<ByteObjectMap<V>, V> withResolved(TypeSerializer vts, BeanProperty property, JsonSerializer<Object> valueSerializer) {
            return new Byte<V>(this._type, property, vts, valueSerializer);
        }
    }
}

