/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.eclipsecollections.deser.map;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.datatype.eclipsecollections.deser.map.KeyHandler;
import com.fasterxml.jackson.datatype.eclipsecollections.deser.map.ValueHandler;
import java.io.IOException;

public abstract class EclipseMapDeserializer<T, I, K extends KeyHandler<K>, V extends ValueHandler<V>>
extends JsonDeserializer<T>
implements ContextualDeserializer {
    private final K keyHandler;
    private final V valueHandler;

    public EclipseMapDeserializer(K keyHandler, V valueHandler) {
        this.keyHandler = keyHandler;
        this.valueHandler = valueHandler;
    }

    public LogicalType logicalType() {
        return LogicalType.Map;
    }

    protected abstract EclipseMapDeserializer<T, ?, ?, ?> withResolved(K var1, V var2);

    protected abstract I createIntermediate();

    protected abstract void deserializeEntry(I var1, K var2, V var3, DeserializationContext var4, String var5, JsonParser var6) throws IOException;

    protected abstract T finish(I var1);

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        Object kc = this.keyHandler.createContextualKey(ctxt, property);
        Object vc = this.valueHandler.createContextualValue(ctxt, property);
        if (kc == this.keyHandler && vc == this.valueHandler) {
            return this;
        }
        return this.withResolved(kc, vc);
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromObject(p, ctxt);
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = p.nextToken();
        }
        if (t != JsonToken.FIELD_NAME && t != JsonToken.END_OBJECT) {
            return (T)ctxt.handleUnexpectedToken(this.handledType(), p);
        }
        I map = this.createIntermediate();
        while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
            String fieldName = p.getCurrentName();
            p.nextToken();
            this.deserializeEntry(map, this.keyHandler, this.valueHandler, ctxt, fieldName, p);
            p.nextToken();
        }
        return this.finish(map);
    }
}

