/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.eclipsecollections.deser.pair;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.ValueInstantiators;
import com.fasterxml.jackson.databind.introspect.AnnotationCollector;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.util.Annotations;
import org.eclipse.collections.api.tuple.Triple;
import org.eclipse.collections.api.tuple.Triplet;
import org.eclipse.collections.impl.tuple.Tuples;

public class TripleInstantiators
extends ValueInstantiators.Base {
    public TripleInstantiators() {
        Triple.class.getName();
    }

    public ValueInstantiator findValueInstantiator(DeserializationConfig config, BeanDescription beanDesc, ValueInstantiator defaultInstantiator) {
        if (beanDesc.getBeanClass() == Triple.class) {
            JavaType beanType = beanDesc.getType();
            return new TripleInstantiator(beanType, beanType.containedType(0), beanType.containedType(1), beanType.containedType(2));
        }
        if (beanDesc.getBeanClass() == Triplet.class) {
            JavaType beanType = beanDesc.getType();
            JavaType singleType = beanType.containedType(0);
            return new TripleInstantiator(beanType, singleType, singleType, singleType);
        }
        return super.findValueInstantiator(config, beanDesc, defaultInstantiator);
    }

    private static class TripleInstantiator
    extends ValueInstantiator.Base {
        private final JavaType oneType;
        private final JavaType twoType;
        private final JavaType threeType;

        private TripleInstantiator(JavaType beanType, JavaType oneType, JavaType twoType, JavaType threeType) {
            super(beanType);
            this.oneType = oneType;
            this.twoType = twoType;
            this.threeType = threeType;
        }

        public boolean canCreateFromObjectWith() {
            return true;
        }

        public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig config) {
            try {
                return new SettableBeanProperty[]{CreatorProperty.construct((PropertyName)PropertyName.construct((String)"one"), (JavaType)this.oneType, null, (TypeDeserializer)config.findTypeDeserializer(this.oneType), (Annotations)AnnotationCollector.emptyAnnotations(), null, (int)0, null, (PropertyMetadata)PropertyMetadata.STD_REQUIRED), CreatorProperty.construct((PropertyName)PropertyName.construct((String)"two"), (JavaType)this.twoType, null, (TypeDeserializer)config.findTypeDeserializer(this.twoType), (Annotations)AnnotationCollector.emptyAnnotations(), null, (int)1, null, (PropertyMetadata)PropertyMetadata.STD_REQUIRED), CreatorProperty.construct((PropertyName)PropertyName.construct((String)"three"), (JavaType)this.threeType, null, (TypeDeserializer)config.findTypeDeserializer(this.threeType), (Annotations)AnnotationCollector.emptyAnnotations(), null, (int)2, null, (PropertyMetadata)PropertyMetadata.STD_REQUIRED)};
            }
            catch (JsonMappingException e) {
                throw new RuntimeException(e);
            }
        }

        public Object createFromObjectWith(DeserializationContext ctxt, Object[] args) {
            return Tuples.triple((Object)args[0], (Object)args[1], (Object)args[2]);
        }
    }
}

