/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.eclipsecollections.ser.map;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.eclipsecollections.ser.map.PrimitiveMapSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.map.MapIterable;

public final class RefRefMapSerializer
extends ContainerSerializer<MapIterable<?, ?>>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    private final JavaType _type;
    private final BeanProperty _property;
    private final JsonSerializer<Object> _keySerializer;
    private final TypeSerializer _valueTypeSerializer;
    private final JsonSerializer<Object> _valueSerializer;
    protected final Set<String> _ignoredEntries;
    protected PropertySerializerMap _dynamicValueSerializers;

    public RefRefMapSerializer(JavaType type, JsonSerializer<Object> keySerializer, TypeSerializer vts, JsonSerializer<Object> valueSerializer, Set<String> ignoredEntries) {
        super(type.getRawClass(), false);
        this._type = type;
        this._property = null;
        this._keySerializer = keySerializer;
        this._valueTypeSerializer = vts;
        this._valueSerializer = valueSerializer;
        this._ignoredEntries = ignoredEntries;
        this._dynamicValueSerializers = PropertySerializerMap.emptyForProperties();
    }

    protected RefRefMapSerializer(RefRefMapSerializer src, BeanProperty property, JsonSerializer<?> keySerializer, TypeSerializer vts, JsonSerializer<?> valueSerializer, Set<String> ignoredEntries) {
        super((ContainerSerializer)src);
        this._type = src._type;
        this._property = property;
        this._keySerializer = keySerializer;
        this._valueTypeSerializer = vts;
        this._valueSerializer = valueSerializer;
        this._dynamicValueSerializers = src._dynamicValueSerializers;
        this._ignoredEntries = ignoredEntries;
    }

    protected RefRefMapSerializer withResolved(BeanProperty property, JsonSerializer<?> keySer, TypeSerializer vts, JsonSerializer<?> valueSer, Set<String> ignored) {
        return new RefRefMapSerializer(this, property, keySer, vts, valueSer, ignored);
    }

    protected ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSer) {
        return new RefRefMapSerializer(this, this._property, this._keySerializer, typeSer, this._valueSerializer, this._ignoredEntries);
    }

    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        Set newIgnored;
        JsonIgnoreProperties.Value ignorals;
        JsonSerializer valueSer = this._valueSerializer;
        if (valueSer == null) {
            JavaType valueType = this.getContentType();
            if (valueType.isFinal()) {
                valueSer = provider.findValueSerializer(valueType, property);
            }
        } else if (valueSer instanceof ContextualSerializer) {
            valueSer = ((ContextualSerializer)valueSer).createContextual(provider, property);
        }
        AnnotationIntrospector intr = provider.getAnnotationIntrospector();
        AnnotatedMember propertyAcc = property == null ? null : property.getMember();
        JsonSerializer keySer = null;
        if (propertyAcc != null && intr != null) {
            Object serDef = intr.findKeySerializer((Annotated)propertyAcc);
            if (serDef != null) {
                keySer = provider.serializerInstance((Annotated)propertyAcc, serDef);
            }
            if ((serDef = intr.findContentSerializer((Annotated)propertyAcc)) != null) {
                valueSer = provider.serializerInstance((Annotated)propertyAcc, serDef);
            }
        }
        if (valueSer == null) {
            valueSer = this._valueSerializer;
        }
        if ((valueSer = this.findContextualConvertingSerializer(provider, property, valueSer)) == null) {
            JavaType valueType = this.getContentType();
            if (valueType.useStaticType()) {
                valueSer = provider.findValueSerializer(valueType, property);
            }
        } else {
            valueSer = provider.handleSecondaryContextualization(valueSer, property);
        }
        if (keySer == null) {
            keySer = this._keySerializer;
        }
        keySer = keySer == null ? provider.findKeySerializer(this.getKeyType(), property) : provider.handleSecondaryContextualization(keySer, property);
        TypeSerializer typeSer = this._valueTypeSerializer;
        if (typeSer != null) {
            typeSer = typeSer.forProperty(property);
        }
        Set<String> ignored = this._ignoredEntries;
        if (intr != null && propertyAcc != null && (ignorals = intr.findPropertyIgnoralByName((MapperConfig)provider.getConfig(), (Annotated)propertyAcc)) != null && (newIgnored = ignorals.findIgnoredForSerialization()) != null && !newIgnored.isEmpty()) {
            ignored = ignored == null ? new HashSet<String>() : new HashSet<String>(ignored);
            ignored.addAll(newIgnored);
        }
        return this.withResolved(property, keySer, typeSer, valueSer, ignored);
    }

    public JsonSerializer<?> getContentSerializer() {
        return this._valueSerializer;
    }

    protected JavaType getKeyType() {
        JavaType[] typeParameters = this._type.findTypeParameters(MapIterable.class);
        return typeParameters.length > 0 ? typeParameters[0] : TypeFactory.unknownType();
    }

    public JavaType getContentType() {
        JavaType[] typeParameters = this._type.findTypeParameters(MapIterable.class);
        return typeParameters.length > 1 ? typeParameters[1] : TypeFactory.unknownType();
    }

    public boolean hasSingleElement(MapIterable<?, ?> map) {
        return map.size() == 1;
    }

    public boolean isEmpty(SerializerProvider prov, MapIterable<?, ?> value) {
        return value.isEmpty();
    }

    public void serialize(MapIterable<?, ?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject(value);
        if (!value.isEmpty()) {
            this.serializeFields(value, gen, provider);
        }
        gen.writeEndObject();
    }

    public void serializeWithType(MapIterable<?, ?> value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        gen.setCurrentValue(value);
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(value, JsonToken.START_OBJECT));
        if (!value.isEmpty()) {
            this.serializeFields(value, gen, provider);
        }
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    private final void serializeFields(MapIterable<?, ?> mmap, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Set<String> ignored = this._ignoredEntries;
        PropertySerializerMap serializers = this._dynamicValueSerializers;
        mmap.forEachKeyValue((Procedure2 & Serializable)(key, v) -> {
            try {
                Class<?> cc;
                if (ignored != null && ignored.contains(key)) {
                    return;
                }
                if (key == null) {
                    provider.findNullKeySerializer(this.getKeyType(), this._property).serialize(null, gen, provider);
                } else {
                    this._keySerializer.serialize(key, gen, provider);
                }
                if (v == null) {
                    provider.defaultSerializeNull(gen);
                    return;
                }
                JsonSerializer<Object> valueSer = this._valueSerializer;
                if (valueSer == null && (valueSer = serializers.serializerFor(cc = v.getClass())) == null) {
                    valueSer = this._findAndAddDynamic(serializers, cc, provider);
                }
                if (this._valueTypeSerializer == null) {
                    valueSer.serialize(v, gen, provider);
                } else {
                    valueSer.serializeWithType(v, gen, provider, this._valueTypeSerializer);
                }
            }
            catch (IOException e) {
                PrimitiveMapSerializer.rethrowUnchecked(e);
            }
        });
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap map, Class<?> type, SerializerProvider provider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSecondarySerializer(type, provider, this._property);
        if (map != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }
}

