/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.hibernate3;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.datatype.hibernate3.Hibernate3Module;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.ElementCollection;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.mapping.Bag;
import org.hibernate.transaction.JDBCTransactionFactory;
import org.hibernate.transaction.TransactionFactory;

public class PersistentCollectionSerializer
extends ContainerSerializer<Object>
implements ContextualSerializer,
ResolvableSerializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _originalType;
    protected final int _features;
    protected final JsonSerializer<Object> _serializer;
    protected final SessionFactory _sessionFactory;

    public PersistentCollectionSerializer(JavaType containerType, JsonSerializer<?> serializer, int features, SessionFactory sessionFactory) {
        super(containerType);
        this._originalType = containerType;
        this._serializer = serializer;
        this._features = features;
        this._sessionFactory = sessionFactory;
    }

    protected PersistentCollectionSerializer(PersistentCollectionSerializer base, JsonSerializer<?> serializer) {
        super((ContainerSerializer)base);
        this._originalType = base._originalType;
        this._serializer = serializer;
        this._features = base._features;
        this._sessionFactory = base._sessionFactory;
    }

    public PersistentCollectionSerializer unwrappingSerializer(NameTransformer unwrapper) {
        return this._withSerializer(this._serializer.unwrappingSerializer(unwrapper));
    }

    protected PersistentCollectionSerializer _withSerializer(JsonSerializer<?> ser) {
        if (ser == this._serializer || ser == null) {
            return this;
        }
        return new PersistentCollectionSerializer(this, ser);
    }

    protected ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        ContainerSerializer<?> ser0 = this._containerSerializer();
        if (ser0 != null) {
            return this._withSerializer((JsonSerializer<?>)ser0.withValueTypeSerializer(vts));
        }
        return this;
    }

    public void resolve(SerializerProvider provider) throws JsonMappingException {
        if (this._serializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)this._serializer).resolve(provider);
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonSerializer ser = provider.handlePrimaryContextualization(this._serializer, property);
        if (!this.usesLazyLoading(property)) {
            return ser;
        }
        return this._withSerializer(ser);
    }

    @Deprecated
    public boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof PersistentCollection) {
            return this.findLazyValue((PersistentCollection)value) == null;
        }
        return this._serializer.isEmpty(value);
    }

    public boolean isEmpty(SerializerProvider provider, Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof PersistentCollection) {
            return this.findLazyValue((PersistentCollection)value) == null;
        }
        return this._serializer.isEmpty(provider, value);
    }

    public boolean isUnwrappingSerializer() {
        return this._serializer.isUnwrappingSerializer();
    }

    public boolean usesObjectId() {
        return this._serializer.usesObjectId();
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this._serializer.acceptJsonFormatVisitor(visitor, typeHint);
    }

    public JavaType getContentType() {
        ContainerSerializer<?> ser = this._containerSerializer();
        if (ser != null) {
            return ser.getContentType();
        }
        return this._originalType.getContentType();
    }

    public JsonSerializer<?> getContentSerializer() {
        ContainerSerializer<?> ser = this._containerSerializer();
        if (ser != null) {
            return ser.getContentSerializer();
        }
        return null;
    }

    public boolean hasSingleElement(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).size() == 1;
        }
        if (value instanceof Map) {
            return ((Map)value).size() == 1;
        }
        return false;
    }

    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value instanceof PersistentCollection) {
            PersistentCollection coll = (PersistentCollection)value;
            if (!Hibernate3Module.Feature.FORCE_LAZY_LOADING.enabledIn(this._features) && !coll.wasInitialized()) {
                provider.defaultSerializeNull(jgen);
                return;
            }
            value = coll.getValue();
            if (value == null) {
                provider.defaultSerializeNull(jgen);
                return;
            }
        }
        if (this._serializer == null) {
            throw JsonMappingException.from((JsonGenerator)jgen, (String)"PersistentCollection does not have serializer set");
        }
        if (Hibernate3Module.Feature.REPLACE_PERSISTENT_COLLECTIONS.enabledIn(this._features)) {
            value = this.convertToJavaCollection(value);
        }
        this._serializer.serialize(value, jgen, provider);
    }

    public void serializeWithType(Object value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        if (value instanceof PersistentCollection) {
            PersistentCollection coll = (PersistentCollection)value;
            if (!Hibernate3Module.Feature.FORCE_LAZY_LOADING.enabledIn(this._features) && !coll.wasInitialized()) {
                provider.defaultSerializeNull(jgen);
                return;
            }
            value = coll.getValue();
            if (value == null) {
                provider.defaultSerializeNull(jgen);
                return;
            }
        }
        if (this._serializer == null) {
            throw JsonMappingException.from((JsonGenerator)jgen, (String)"PersistentCollection does not have serializer set");
        }
        if (Hibernate3Module.Feature.REPLACE_PERSISTENT_COLLECTIONS.enabledIn(this._features)) {
            value = this.convertToJavaCollection(value);
        }
        this._serializer.serializeWithType(value, jgen, provider, typeSer);
    }

    protected ContainerSerializer<?> _containerSerializer() {
        if (this._serializer instanceof ContainerSerializer) {
            return (ContainerSerializer)this._serializer;
        }
        return null;
    }

    protected Object findLazyValue(PersistentCollection coll) {
        if (!Hibernate3Module.Feature.FORCE_LAZY_LOADING.enabledIn(this._features) && !coll.wasInitialized()) {
            return null;
        }
        if (this._sessionFactory != null) {
            org.hibernate.Session session = this.openTemporarySessionForLoading(coll);
            this.initializeCollection(coll, session);
        }
        return coll.getValue();
    }

    private org.hibernate.Session openTemporarySessionForLoading(PersistentCollection coll) {
        SessionFactory sf = this._sessionFactory;
        Session session = sf.openSession();
        PersistenceContext persistenceContext = ((SessionImplementor)session).getPersistenceContext();
        persistenceContext.setDefaultReadOnly(true);
        session.setFlushMode(FlushMode.MANUAL);
        persistenceContext.addUninitializedDetachedCollection(((SessionFactoryImplementor)this._sessionFactory).getCollectionPersister(coll.getRole()), coll);
        return session;
    }

    private void initializeCollection(PersistentCollection coll, org.hibernate.Session session) {
        SessionFactoryImpl sessionFactoryImpl = (SessionFactoryImpl)((SessionImplementor)session).getFactory();
        TransactionFactory transactionFactory = sessionFactoryImpl.getTransactionFactory();
        boolean isJTA = true;
        if (transactionFactory instanceof JDBCTransactionFactory) {
            isJTA = false;
        }
        if (!isJTA) {
            session.beginTransaction();
        }
        coll.setCurrentSession((SessionImplementor)session);
        Hibernate.initialize((Object)coll);
        if (!isJTA) {
            session.getTransaction().commit();
        }
        session.close();
    }

    protected boolean usesLazyLoading(BeanProperty property) {
        if (property != null) {
            ElementCollection ec = (ElementCollection)property.getAnnotation(ElementCollection.class);
            if (ec != null) {
                return ec.fetch() == FetchType.LAZY;
            }
            OneToMany ann1 = (OneToMany)property.getAnnotation(OneToMany.class);
            if (ann1 != null) {
                return ann1.fetch() == FetchType.LAZY;
            }
            OneToOne ann2 = (OneToOne)property.getAnnotation(OneToOne.class);
            if (ann2 != null) {
                return ann2.fetch() == FetchType.LAZY;
            }
            ManyToOne ann3 = (ManyToOne)property.getAnnotation(ManyToOne.class);
            if (ann3 != null) {
                return ann3.fetch() == FetchType.LAZY;
            }
            ManyToMany ann4 = (ManyToMany)property.getAnnotation(ManyToMany.class);
            if (ann4 != null) {
                return ann4.fetch() == FetchType.LAZY;
            }
            return !Hibernate3Module.Feature.REQUIRE_EXPLICIT_LAZY_LOADING_MARKER.enabledIn(this._features);
        }
        return false;
    }

    private Object convertToJavaCollection(Object value) {
        if (!(value instanceof PersistentCollection)) {
            return value;
        }
        if (value instanceof Set) {
            return this.convertToSet((Set)value);
        }
        if (value instanceof List || value instanceof Bag) {
            return this.convertToList((List)value);
        }
        if (value instanceof Map) {
            return this.convertToMap((Map)value);
        }
        throw new IllegalArgumentException("Unsupported type: " + value.getClass());
    }

    private Object convertToList(List<?> value) {
        return new ArrayList(value);
    }

    private Object convertToMap(Map<?, ?> value) {
        return new HashMap(value);
    }

    private Object convertToSet(Set<?> value) {
        return new HashSet(value);
    }
}

