/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.hibernate3;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.datatype.hibernate3.HibernateAnnotationIntrospector;
import com.fasterxml.jackson.datatype.hibernate3.HibernateSerializerModifier;
import com.fasterxml.jackson.datatype.hibernate3.HibernateSerializers;
import com.fasterxml.jackson.datatype.hibernate3.PackageVersion;
import org.hibernate.SessionFactory;

public class Hibernate3Module
extends Module {
    protected static final int DEFAULT_FEATURES = Feature.collectDefaults();
    protected int _moduleFeatures = DEFAULT_FEATURES;
    protected final SessionFactory _sessionFactory;

    public Hibernate3Module() {
        this(null);
    }

    public Hibernate3Module(SessionFactory sessionFactory) {
        this._sessionFactory = sessionFactory;
    }

    public String getModuleName() {
        return "jackson-datatype-hibernate";
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public void setupModule(Module.SetupContext context) {
        AnnotationIntrospector ai = this.annotationIntrospector();
        if (ai != null) {
            context.appendAnnotationIntrospector(ai);
        }
        context.addSerializers((Serializers)new HibernateSerializers(this._moduleFeatures));
        context.addBeanSerializerModifier((BeanSerializerModifier)new HibernateSerializerModifier(this._moduleFeatures, this._sessionFactory));
    }

    protected AnnotationIntrospector annotationIntrospector() {
        HibernateAnnotationIntrospector ai = new HibernateAnnotationIntrospector();
        ai.setUseTransient(this.isEnabled(Feature.USE_TRANSIENT_ANNOTATION));
        return ai;
    }

    public Hibernate3Module enable(Feature f) {
        this._moduleFeatures |= f.getMask();
        return this;
    }

    public Hibernate3Module disable(Feature f) {
        this._moduleFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(Feature f) {
        return (this._moduleFeatures & f.getMask()) != 0;
    }

    public Hibernate3Module configure(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public static enum Feature {
        FORCE_LAZY_LOADING(false),
        USE_TRANSIENT_ANNOTATION(true),
        REQUIRE_EXPLICIT_LAZY_LOADING_MARKER(false),
        REPLACE_PERSISTENT_COLLECTIONS(false);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledIn(int flags) {
            return (flags & this._mask) != 0;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

