/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.hibernate4;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.beans.Introspector;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.persistence.EntityNotFoundException;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.proxy.pojo.BasicLazyInitializer;

public class HibernateProxySerializer
extends JsonSerializer<HibernateProxy>
implements ContextualSerializer {
    protected final BeanProperty _property;
    protected final boolean _forceLazyLoading;
    protected final boolean _serializeIdentifier;
    protected final boolean _nullMissingEntities;
    protected final boolean _wrappedIdentifier;
    protected final Mapping _mapping;
    protected final NameTransformer _unwrapper;
    protected PropertySerializerMap _dynamicSerializers;

    @Deprecated
    public HibernateProxySerializer(boolean forceLazyLoading) {
        this(forceLazyLoading, false, false, true, null, null, null);
    }

    @Deprecated
    public HibernateProxySerializer(boolean forceLazyLoading, boolean serializeIdentifier) {
        this(forceLazyLoading, serializeIdentifier, false, true, null, null, null);
    }

    @Deprecated
    public HibernateProxySerializer(boolean forceLazyLoading, boolean serializeIdentifier, Mapping mapping) {
        this(forceLazyLoading, serializeIdentifier, false, true, mapping, null, null);
    }

    @Deprecated
    public HibernateProxySerializer(boolean forceLazyLoading, boolean serializeIdentifier, boolean nullMissingEntities, Mapping mapping) {
        this(forceLazyLoading, serializeIdentifier, nullMissingEntities, true, mapping, null, null);
    }

    @Deprecated
    public HibernateProxySerializer(boolean forceLazyLoading, boolean serializeIdentifier, boolean nullMissingEntities, Mapping mapping, BeanProperty property) {
        this(forceLazyLoading, serializeIdentifier, nullMissingEntities, true, mapping, property, null);
    }

    public HibernateProxySerializer(boolean forceLazyLoading, boolean serializeIdentifier, boolean nullMissingEntities, boolean wrappedIdentifier, Mapping mapping) {
        this(forceLazyLoading, serializeIdentifier, nullMissingEntities, wrappedIdentifier, mapping, null, null);
    }

    public HibernateProxySerializer(boolean forceLazyLoading, boolean serializeIdentifier, boolean nullMissingEntities, boolean wrappedIdentifier, Mapping mapping, BeanProperty property, NameTransformer unwrapper) {
        this._forceLazyLoading = forceLazyLoading;
        this._serializeIdentifier = serializeIdentifier;
        this._nullMissingEntities = nullMissingEntities;
        this._wrappedIdentifier = wrappedIdentifier;
        this._mapping = mapping;
        this._property = property;
        this._unwrapper = unwrapper;
        this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
    }

    protected HibernateProxySerializer(HibernateProxySerializer base, BeanProperty property, NameTransformer unwrapper) {
        this._forceLazyLoading = base._forceLazyLoading;
        this._serializeIdentifier = base._serializeIdentifier;
        this._nullMissingEntities = base._nullMissingEntities;
        this._wrappedIdentifier = base._wrappedIdentifier;
        this._mapping = base._mapping;
        this._property = property;
        this._unwrapper = unwrapper;
        this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) {
        return new HibernateProxySerializer(this, property, this._unwrapper);
    }

    public JsonSerializer<HibernateProxy> unwrappingSerializer(NameTransformer unwrapper) {
        return new HibernateProxySerializer(this, this._property, unwrapper);
    }

    public boolean isUnwrappingSerializer() {
        return this._unwrapper != null;
    }

    public boolean isEmpty(SerializerProvider provider, HibernateProxy value) {
        return value == null || this.findProxied(value) == null;
    }

    public void serialize(HibernateProxy value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        Object proxiedValue = this.findProxied(value);
        if (proxiedValue == null) {
            provider.defaultSerializeNull(jgen);
            return;
        }
        this.findSerializer(provider, proxiedValue).serialize(proxiedValue, jgen, provider);
    }

    public void serializeWithType(HibernateProxy value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        Object proxiedValue = this.findProxied(value);
        if (proxiedValue == null) {
            provider.defaultSerializeNull(jgen);
            return;
        }
        this.findSerializer(provider, proxiedValue).serializeWithType(proxiedValue, jgen, provider, typeSer);
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        SerializerProvider prov = visitor.getProvider();
        if (prov == null || this._property == null) {
            super.acceptJsonFormatVisitor(visitor, typeHint);
        } else {
            JavaType type = this._property.getType();
            prov.findPrimaryPropertySerializer(type, this._property).acceptJsonFormatVisitor(visitor, type);
        }
    }

    protected JsonSerializer<Object> findSerializer(SerializerProvider provider, Object value) throws IOException {
        Class<?> type = value.getClass();
        PropertySerializerMap.SerializerAndMapResult result = this._dynamicSerializers.findAndAddPrimarySerializer(type, provider, this._property);
        if (this._dynamicSerializers != result.map) {
            this._dynamicSerializers = result.map;
        }
        if (this._unwrapper != null) {
            return result.serializer.unwrappingSerializer(this._unwrapper);
        }
        return result.serializer;
    }

    protected Object findProxied(HibernateProxy proxy) {
        LazyInitializer init = proxy.getHibernateLazyInitializer();
        if (!this._forceLazyLoading && init.isUninitialized()) {
            if (this._serializeIdentifier) {
                HashMap result;
                HashMap idValue = init.getIdentifier();
                if (this._wrappedIdentifier) {
                    HashMap map = new HashMap();
                    map.put(this.getIdentifierPropertyName(init), idValue);
                    result = map;
                } else {
                    result = idValue;
                }
                return result;
            }
            return null;
        }
        try {
            return init.getImplementation();
        }
        catch (EntityNotFoundException e) {
            if (this._nullMissingEntities) {
                return null;
            }
            throw e;
        }
    }

    private String getIdentifierPropertyName(LazyInitializer init) {
        String idName;
        if (this._mapping != null) {
            idName = this._mapping.getIdentifierPropertyName(init.getEntityName());
        } else {
            SessionImplementor session = init.getSession();
            if (session != null) {
                idName = session.getFactory().getIdentifierPropertyName(init.getEntityName());
            } else {
                idName = ProxyReader.getIdentifierPropertyName(init);
                if (idName == null) {
                    idName = init.getEntityName();
                }
            }
        }
        return idName;
    }

    protected static class ProxyReader {
        private static final Field getIdentifierMethodField;

        protected ProxyReader() {
        }

        static String getIdentifierPropertyName(LazyInitializer init) {
            try {
                Method idGetter = (Method)getIdentifierMethodField.get(init);
                if (idGetter == null) {
                    return null;
                }
                String name = idGetter.getName();
                if (name.startsWith("get")) {
                    name = Introspector.decapitalize(name.substring(3));
                }
                return name;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        static {
            try {
                getIdentifierMethodField = BasicLazyInitializer.class.getDeclaredField("getIdentifierMethod");
                getIdentifierMethodField.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

