/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jaxrs;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import javax.ws.rs.core.Link;

public class LinkDeserializer
extends StdScalarDeserializer<Link> {
    private static final long serialVersionUID = 1L;

    public LinkDeserializer() {
        super(Link.class);
    }

    public Link deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String text = p.getValueAsString();
        if (text != null) {
            return Link.valueOf((String)text);
        }
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p.nextToken();
            Link value = this.deserialize(p, ctxt);
            if (p.nextToken() != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p, ctxt);
            }
            return value;
        }
        if (t == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object ob = p.getEmbeddedObject();
            if (ob == null) {
                return null;
            }
            if (ob instanceof Link) {
                return (Link)ob;
            }
        }
        return (Link)ctxt.handleUnexpectedToken(this._valueClass, p);
    }
}

