/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jodamoney;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collections;
import org.joda.money.CurrencyUnit;
import org.joda.money.Money;

public class MoneyDeserializer
extends StdDeserializer<Money> {
    private static final long serialVersionUID = 1L;

    public MoneyDeserializer() {
        super(Money.class);
    }

    public LogicalType logicalType() {
        return LogicalType.POJO;
    }

    public Money deserialize(JsonParser p, DeserializationContext context) throws IOException {
        BigDecimal amount = null;
        CurrencyUnit currencyUnit = null;
        if (p.isExpectedStartObjectToken()) {
            p.nextToken();
        }
        while (p.currentToken() == JsonToken.FIELD_NAME) {
            String field = p.currentName();
            p.nextToken();
            if ("amount".equals(field)) {
                amount = (BigDecimal)context.readValue(p, BigDecimal.class);
            } else if ("currency".equals(field)) {
                currencyUnit = (CurrencyUnit)context.readValue(p, CurrencyUnit.class);
            } else {
                if (context.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
                    throw UnrecognizedPropertyException.from((JsonParser)p, Money.class, (String)field, Collections.singletonList("amount, currency"));
                }
                p.skipChildren();
            }
            p.nextToken();
        }
        return Money.of(currencyUnit, amount);
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromObject(p, ctxt);
    }
}

