/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jodamoney;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.datatype.jodamoney.JodaMoneySerializerBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.joda.money.Money;

public class MoneySerializer
extends JodaMoneySerializerBase<Money> {
    private static final long serialVersionUID = 1L;

    public MoneySerializer() {
        super(Money.class);
    }

    public void serialize(Money value, JsonGenerator g, SerializerProvider context) throws IOException {
        g.writeStartObject();
        this._writeFields(value, g, context);
        g.writeEndObject();
    }

    @Override
    public void serializeWithType(Money value, JsonGenerator g, SerializerProvider context, TypeSerializer typeSer) throws IOException {
        g.setCurrentValue((Object)value);
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId((Object)value, JsonToken.START_OBJECT));
        this._writeFields(value, g, context);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    private final void _writeFields(Money money, JsonGenerator g, SerializerProvider context) throws IOException {
        BigDecimal decimal = money.getAmount();
        int decimalPlaces = money.getCurrencyUnit().getDecimalPlaces();
        int scale = Math.max(decimal.scale(), decimalPlaces);
        g.writeNumberField("amount", decimal.setScale(scale, RoundingMode.UNNECESSARY));
        g.writeFieldName("currency");
        context.defaultSerializeValue((Object)money.getCurrencyUnit(), g);
    }
}

