/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jodamoney;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import org.joda.money.CurrencyUnit;

public class CurrencyUnitDeserializer
extends StdScalarDeserializer<CurrencyUnit> {
    private static final long serialVersionUID = 1L;

    public CurrencyUnitDeserializer() {
        super(CurrencyUnit.class);
    }

    public CurrencyUnit deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            String currencyCode = p.getText();
            try {
                return CurrencyUnit.of((String)currencyCode);
            }
            catch (Exception e) {
                return (CurrencyUnit)ctxt.handleWeirdStringValue(this.handledType(), currencyCode, e.getMessage(), new Object[0]);
            }
        }
        return (CurrencyUnit)ctxt.handleUnexpectedToken(this.handledType(), p.currentToken(), p, "Expected a `JsonToken.VALUE_STRING`, got `JsonToken.%s`", new Object[]{p.currentToken()});
    }
}

