/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jodamoney;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import org.joda.money.CurrencyUnit;
import org.joda.money.Money;

public class MoneyDeserializer
extends StdDeserializer<Money> {
    private static final long serialVersionUID = 1L;
    private final String F_AMOUNT = "amount";
    private final String F_CURRENCY = "currency";

    public MoneyDeserializer() {
        super(Money.class);
    }

    public LogicalType logicalType() {
        return LogicalType.POJO;
    }

    public Collection<Object> getKnownPropertyNames() {
        return Arrays.asList("amount", "currency");
    }

    public Money deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String missingName;
        BigDecimal amount = null;
        CurrencyUnit currencyUnit = null;
        if (p.isExpectedStartObjectToken()) {
            p.nextToken();
        }
        while (p.currentToken() == JsonToken.FIELD_NAME) {
            String field = p.currentName();
            p.nextToken();
            switch (field) {
                case "amount": {
                    amount = (BigDecimal)ctxt.readValue(p, BigDecimal.class);
                    break;
                }
                case "currency": {
                    currencyUnit = (CurrencyUnit)ctxt.readValue(p, CurrencyUnit.class);
                    break;
                }
                default: {
                    ctxt.handleUnknownProperty(p, (JsonDeserializer)this, (Object)this.handledType(), field);
                }
            }
            p.nextToken();
        }
        if (amount == null) {
            missingName = "amount";
        } else if (currencyUnit == null) {
            missingName = "currency";
        } else {
            return Money.of(currencyUnit, amount);
        }
        return (Money)ctxt.reportPropertyInputMismatch(this.getValueType(ctxt), missingName, "Property '%s' missing from Object value", new Object[]{missingName});
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromObject(p, ctxt);
    }
}

