/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.pcollections;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.datatype.pcollections.deser.ConsPStackDeserializer;
import com.fasterxml.jackson.datatype.pcollections.deser.HashTreePBagDeserializer;
import com.fasterxml.jackson.datatype.pcollections.deser.HashTreePMapDeserializer;
import com.fasterxml.jackson.datatype.pcollections.deser.HashTreePSetDeserializer;
import com.fasterxml.jackson.datatype.pcollections.deser.OrderedPSetDeserializer;
import com.fasterxml.jackson.datatype.pcollections.deser.TreePVectorDeserializer;
import org.pcollections.ConsPStack;
import org.pcollections.HashPMap;
import org.pcollections.MapPBag;
import org.pcollections.MapPSet;
import org.pcollections.OrderedPSet;
import org.pcollections.PCollection;
import org.pcollections.PMap;
import org.pcollections.TreePVector;

public class PCollectionsDeserializers
extends Deserializers.Base {
    public JsonDeserializer<?> findCollectionDeserializer(CollectionType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        Class raw = type.getRawClass();
        if (PCollection.class.isAssignableFrom(raw)) {
            if (raw.isAssignableFrom(TreePVector.class)) {
                return new TreePVectorDeserializer(type, elementTypeDeserializer, elementDeserializer);
            }
            if (raw.isAssignableFrom(ConsPStack.class)) {
                return new ConsPStackDeserializer(type, elementTypeDeserializer, elementDeserializer);
            }
            if (raw.isAssignableFrom(MapPSet.class)) {
                return new HashTreePSetDeserializer(type, elementTypeDeserializer, elementDeserializer);
            }
            if (raw.isAssignableFrom(OrderedPSet.class)) {
                return new OrderedPSetDeserializer(type, elementTypeDeserializer, elementDeserializer);
            }
            if (raw.isAssignableFrom(MapPBag.class)) {
                return new HashTreePBagDeserializer(type, elementTypeDeserializer, elementDeserializer);
            }
        }
        return null;
    }

    public JsonDeserializer<?> findMapDeserializer(MapType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        Class raw = type.getRawClass();
        if (PMap.class.isAssignableFrom(raw) && raw.isAssignableFrom(HashPMap.class)) {
            return new HashTreePMapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }
        return null;
    }
}

