/*
 * Decompiled with CFR 0.152.
 */
package com.fengwenyi.api.result;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fengwenyi.api.result.IReturnCode;
import com.fengwenyi.api.result.ResultHeader;
import java.io.Serializable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ResultTemplate<T>
implements Serializable {
    private static final long serialVersionUID = -4206473602305400988L;
    private static final IReturnCode DEFAULT_SUCCESS = IReturnCode.Default.SUCCESS;
    private static final IReturnCode DEFAULT_ERROR = IReturnCode.Default.ERROR_COMMON_EXCEPTION;
    private String code;
    private String message;
    private Boolean success = Boolean.FALSE;
    private ResultHeader header;
    private T body;

    public ResultTemplate() {
    }

    public ResultTemplate(String code, String message, Boolean success, ResultHeader header, T body) {
        this.code = code;
        this.message = message;
        this.success = success;
        this.header = header;
        this.body = body;
    }

    public ResultTemplate(String code, String message, Boolean success, T body) {
        this.code = code;
        this.message = message;
        this.success = success;
        this.body = body;
    }

    public ResultTemplate(IReturnCode iReturnCode, Boolean success, T body) {
        this.code = iReturnCode.getCode();
        this.message = iReturnCode.getMessage();
        this.success = success;
        this.body = body;
    }

    public static <T> ResultTemplate<T> success() {
        return new ResultTemplate<T>().setSuccess(Boolean.TRUE).setCode(DEFAULT_SUCCESS.getCode()).setMessage(DEFAULT_SUCCESS.getMessage());
    }

    public static <T> ResultTemplate<T> success(T body) {
        return new ResultTemplate<T>().setSuccess(Boolean.TRUE).setCode(DEFAULT_SUCCESS.getCode()).setMessage(DEFAULT_SUCCESS.getMessage()).setBody(body);
    }

    public static <T> ResultTemplate<T> success(String code, String message) {
        return new ResultTemplate<T>().setSuccess(Boolean.TRUE).setCode(code).setMessage(message);
    }

    public static <T> ResultTemplate<T> success(String code, String message, T body) {
        return new ResultTemplate<T>().setSuccess(Boolean.TRUE).setCode(code).setMessage(message).setBody(body);
    }

    public static <T> ResultTemplate<T> fail() {
        return new ResultTemplate<T>().setCode(DEFAULT_ERROR.getCode()).setMessage(DEFAULT_ERROR.getMessage());
    }

    public static <T> ResultTemplate<T> fail(String message) {
        return new ResultTemplate<T>().setCode(DEFAULT_ERROR.getCode()).setMessage(message);
    }

    public static <T> ResultTemplate<T> fail(String code, String message) {
        return new ResultTemplate<T>().setCode(code).setMessage(message);
    }

    public static <T> ResultTemplate<T> fail(IReturnCode error) {
        return new ResultTemplate<T>().setCode(error.getCode()).setMessage(error.getMessage());
    }

    public String getCode() {
        return this.code;
    }

    public ResultTemplate<T> setCode(String code) {
        this.code = code;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public ResultTemplate<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public ResultTemplate<T> setSuccess(Boolean success) {
        this.success = success;
        return this;
    }

    public ResultHeader getHeader() {
        return this.header;
    }

    public ResultTemplate<T> setHeader(ResultHeader header) {
        this.header = header;
        return this;
    }

    public T getBody() {
        return this.body;
    }

    public ResultTemplate<T> setBody(T body) {
        this.body = body;
        return this;
    }

    public String toString() {
        return "ResultTemplate{code='" + this.code + '\'' + ", message='" + this.message + '\'' + ", success=" + this.success + ", header=" + this.header + ", body=" + this.body + '}';
    }
}

