/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.extractor;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.HttpRequestExtractor;
import com.github.dreamhead.moco.extractor.ContentRequestExtractor;
import com.github.dreamhead.moco.model.MessageContent;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;

public final class JsonPathRequestExtractor
extends HttpRequestExtractor<Object> {
    private final ContentRequestExtractor extractor = new ContentRequestExtractor();
    private final JsonPath jsonPath;

    public JsonPathRequestExtractor(String jsonPath) {
        this.jsonPath = JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]);
    }

    @Override
    protected Optional<Object> doExtract(HttpRequest request) {
        Optional<MessageContent> requestBody = this.extractor.extract(request);
        try {
            if (!requestBody.isPresent()) {
                return Optional.empty();
            }
            MessageContent content = requestBody.get();
            Object jsonPathContent = this.jsonPath.read((InputStream)new ByteArrayInputStream(content.getContent()), content.getCharset().toString(), Configuration.defaultConfiguration());
            if (jsonPathContent == null) {
                return Optional.empty();
            }
            return Optional.of(this.toStringArray(jsonPathContent));
        }
        catch (PathNotFoundException | IOException e) {
            return Optional.empty();
        }
    }

    private Object toStringArray(Object content) {
        if (content instanceof List) {
            List list = (List)content;
            return list.stream().map(Object::toString).toArray(String[]::new);
        }
        return content.toString();
    }
}

