/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.internal;

import com.github.dreamhead.moco.HttpsCertificate;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.MocoMonitor;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.WebSocketServer;
import com.github.dreamhead.moco.dumper.HttpRequestDumper;
import com.github.dreamhead.moco.dumper.HttpResponseDumper;
import com.github.dreamhead.moco.internal.HttpConfiguration;
import com.github.dreamhead.moco.internal.ServerConfig;
import com.github.dreamhead.moco.monitor.QuietMonitor;
import com.github.dreamhead.moco.monitor.Slf4jMonitor;
import com.github.dreamhead.moco.monitor.ThreadSafeMonitor;
import com.github.dreamhead.moco.setting.HttpSetting;
import com.github.dreamhead.moco.util.Preconditions;
import com.github.dreamhead.moco.websocket.ActualWebSocketServer;
import io.netty.handler.ssl.SslHandler;
import java.util.Optional;
import javax.net.ssl.SSLEngine;

public class ActualHttpServer
extends HttpConfiguration<ActualHttpServer> {
    private static final int MAX_HEADER_SIZE = 8192;
    private static final int MAX_CONTENT_LENGTH = 0x100000;
    private final HttpsCertificate certificate;
    private final ServerConfig serverConfig;
    private ActualWebSocketServer websocketServer;

    protected ActualHttpServer(int port, HttpsCertificate certificate, MocoMonitor monitor, MocoConfig ... configs) {
        this(port, certificate, monitor, new ServerConfig(8192, 0x100000), configs);
    }

    protected ActualHttpServer(int port, HttpsCertificate certificate, MocoMonitor monitor, ServerConfig serverConfig, MocoConfig ... configs) {
        super(port, monitor, configs);
        this.certificate = certificate;
        this.serverConfig = serverConfig;
    }

    public final ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public final boolean isSecure() {
        return this.certificate != null;
    }

    public final Optional<SslHandler> sslHandler() {
        if (this.certificate != null) {
            return Optional.of(this.asSslHandler(this.certificate));
        }
        return Optional.empty();
    }

    private SslHandler asSslHandler(HttpsCertificate certificate) {
        SSLEngine sslEngine = certificate.createSSLEngine();
        sslEngine.setUseClientMode(false);
        return new SslHandler(sslEngine);
    }

    @Override
    protected final ActualHttpServer createMergeServer(ActualHttpServer thatServer) {
        return this.newBaseServer(this.mergePort(this, thatServer).orElse(0), this.mergedCertificate(this.certificate, thatServer.certificate));
    }

    private Optional<Integer> mergePort(ActualHttpServer thisServer, ActualHttpServer thatServer) {
        Optional<Integer> optionalPort = thisServer.getPort();
        if (optionalPort.isPresent() && optionalPort.get() != 0) {
            return optionalPort;
        }
        return thatServer.getPort();
    }

    private HttpsCertificate mergedCertificate(HttpsCertificate one, HttpsCertificate other) {
        if (one != null) {
            return one;
        }
        return other;
    }

    private ActualHttpServer newBaseServer(int port, HttpsCertificate certificate) {
        if (certificate != null) {
            return ActualHttpServer.createHttpsLogServer(port, certificate, new MocoConfig[0]);
        }
        return ActualHttpServer.createLogServer(port, new MocoConfig[0]);
    }

    public static ActualHttpServer createHttpServerWithMonitor(int port, MocoMonitor monitor, MocoConfig ... configs) {
        return new ActualHttpServer(port, null, (MocoMonitor)new ThreadSafeMonitor(monitor), configs);
    }

    public static ActualHttpServer createLogServer(int port, MocoConfig ... configs) {
        return ActualHttpServer.createHttpServerWithMonitor(port, new Slf4jMonitor(new HttpRequestDumper(), new HttpResponseDumper()), configs);
    }

    public static ActualHttpServer createQuietServer(int port, MocoConfig ... configs) {
        return ActualHttpServer.createHttpServerWithMonitor(port, new QuietMonitor(), configs);
    }

    public static ActualHttpServer createHttpsServerWithMonitor(int port, HttpsCertificate certificate, MocoMonitor monitor, MocoConfig ... configs) {
        return new ActualHttpServer(port, certificate, monitor, configs);
    }

    public static ActualHttpServer createHttpsLogServer(int port, HttpsCertificate certificate, MocoConfig ... configs) {
        return ActualHttpServer.createHttpsServerWithMonitor(port, certificate, new Slf4jMonitor(new HttpRequestDumper(), new HttpResponseDumper()), configs);
    }

    public static ActualHttpServer createHttpsQuietServer(int port, HttpsCertificate certificate, MocoConfig ... configs) {
        return ActualHttpServer.createHttpsServerWithMonitor(port, certificate, new QuietMonitor(), configs);
    }

    public static ActualHttpServer createHttpsServer(int port, HttpsCertificate certificate, MocoMonitor monitor, ServerConfig serverConfig, MocoConfig ... configs) {
        return new ActualHttpServer(port, certificate, monitor, serverConfig, configs);
    }

    protected final HttpSetting newSetting(RequestMatcher matcher) {
        return new HttpSetting(matcher);
    }

    @Override
    protected void addExtension(ActualHttpServer server) {
        this.websocketServer = server.websocketServer;
    }

    @Override
    public WebSocketServer websocket(String uri) {
        com.google.common.base.Preconditions.checkArgument((this.websocketServer == null ? 1 : 0) != 0, (Object)"Only one websocket can be setup");
        this.websocketServer = new ActualWebSocketServer(Preconditions.checkNotNullOrEmpty(uri, "uri should not be null or empty"));
        return this.websocketServer;
    }

    public final ActualWebSocketServer getWebsocketServer() {
        return this.websocketServer;
    }
}

