/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.internal;

import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.Response;
import com.github.dreamhead.moco.internal.ActualSocketServer;
import com.github.dreamhead.moco.internal.SessionContext;
import com.github.dreamhead.moco.model.DefaultSocketRequest;
import com.github.dreamhead.moco.model.DefaultSocketResponse;
import com.github.dreamhead.moco.model.MessageContent;
import com.github.dreamhead.moco.util.ByteBufs;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.InputStream;
import java.util.Optional;

@ChannelHandler.Sharable
public final class MocoSocketHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final ActualSocketServer server;

    public MocoSocketHandler(ActualSocketServer server) {
        this.server = server;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
        MessageContent content = MessageContent.content().withContent((InputStream)new ByteBufInputStream(msg)).build();
        DefaultSocketRequest request = new DefaultSocketRequest(content);
        SessionContext context = new SessionContext(request, new DefaultSocketResponse());
        Optional<Response> response = this.server.getResponse(context);
        Response actual = response.orElseThrow(() -> new MocoException(String.format("No handler found for request: %s", context.getRequest().getContent())));
        ctx.write((Object)ByteBufs.toByteBuf(actual.getContent().getContent()));
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.server.onException(cause);
    }
}

