/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.matcher;

import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.extractor.ContentRequestExtractor;
import com.github.dreamhead.moco.extractor.XmlExtractorHelper;
import com.github.dreamhead.moco.matcher.AbstractRequestMatcher;
import com.github.dreamhead.moco.resource.Resource;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlRequestMatcher
extends AbstractRequestMatcher {
    private final XmlExtractorHelper helper = new XmlExtractorHelper();
    private final ContentRequestExtractor extractor = new ContentRequestExtractor();
    private final Resource resource;

    public XmlRequestMatcher(Resource resource) {
        this.resource = resource;
    }

    @Override
    public boolean match(Request request) {
        try {
            Optional<Document> requestDocument = this.extractDocument(request, this.extractor);
            return requestDocument.isPresent() && this.tryToMatch(request, requestDocument.get());
        }
        catch (SAXException e) {
            return false;
        }
    }

    private boolean tryToMatch(Request request, Document document) throws SAXException {
        Document resourceDocument = this.getResourceDocument(request, this.resource);
        return document.isEqualNode(resourceDocument);
    }

    @Override
    public RequestMatcher doApply(MocoConfig config) {
        if (config.isFor(this.resource.id())) {
            return new XmlRequestMatcher(this.resource.apply(config));
        }
        return this;
    }

    private Document getResourceDocument(Request request, Resource resource) throws SAXException {
        InputStream stream = resource.readFor(request).toInputStream();
        return this.extractDocument(new InputSource(stream));
    }

    private Optional<Document> extractDocument(Request request, ContentRequestExtractor extractor) throws SAXException {
        Optional<InputSource> inputSourceOptional = this.helper.extractAsInputSource(request, extractor);
        if (!inputSourceOptional.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.extractDocument(inputSourceOptional.get()));
    }

    private void trimChild(Node node, Node child) {
        if (child instanceof Text) {
            if (Strings.isNullOrEmpty((String)child.getNodeValue().trim())) {
                node.removeChild(child);
            }
            return;
        }
        if (child instanceof Element) {
            this.trimNode(child);
        }
    }

    private void trimNode(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = children.getLength() - 1; i >= 0; --i) {
            this.trimChild(node, children.item(i));
        }
    }

    private DocumentBuilder documentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setCoalescing(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setIgnoringComments(true);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new MocoException(e);
        }
    }

    private Document extractDocument(InputSource inputSource) throws SAXException {
        try {
            DocumentBuilder builder = this.documentBuilder();
            Document document = builder.parse(inputSource);
            document.normalizeDocument();
            this.trimNode(document);
            return document;
        }
        catch (IOException e) {
            throw new MocoException(e);
        }
    }
}

