/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.monitor;

import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.monitor.LogWriter;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;

public final class FileLogWriter
implements LogWriter {
    private final File file;
    private final Charset charset;

    public FileLogWriter(String filename, Charset charset) {
        this.file = new File(filename);
        this.charset = this.asCharset(charset);
    }

    private Charset asCharset(Charset charset) {
        if (charset != null) {
            return charset;
        }
        return Charset.defaultCharset();
    }

    @Override
    public void write(String content) {
        try {
            Files.asCharSink((File)this.file, (Charset)this.charset, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}).write((CharSequence)content);
        }
        catch (Exception e) {
            throw new MocoException(e);
        }
    }
}

