/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.recorder;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.handler.AbstractResponseHandler;
import com.github.dreamhead.moco.internal.SessionContext;
import com.github.dreamhead.moco.recorder.RecorderConfig;
import com.github.dreamhead.moco.recorder.RecorderConfigurations;
import com.github.dreamhead.moco.recorder.RecorderIdentifier;
import com.github.dreamhead.moco.recorder.RecorderRegistry;
import com.github.dreamhead.moco.recorder.ReplayModifier;
import com.github.dreamhead.moco.recorder.RequestRecorder;
import com.google.common.collect.ImmutableList;

public class DynamicReplayHandler
extends AbstractResponseHandler {
    private final RecorderRegistry registry;
    private final RecorderIdentifier identifier;
    private final ReplayModifier modifier;

    public DynamicReplayHandler(RecorderConfigurations configurations) {
        this.registry = configurations.getRecorderRegistry();
        this.identifier = configurations.getIdentifier();
        this.modifier = configurations.getModifier();
    }

    private HttpRequest getRequiredRecordedRequest(HttpRequest request) {
        HttpRequest recordedRequest = this.getRecordedRequest(request);
        if (recordedRequest == null) {
            throw new IllegalArgumentException("No recorded request for [" + this.identifier + "]");
        }
        return recordedRequest;
    }

    protected final HttpRequest getRecordedRequest(HttpRequest request) {
        String name = this.identifier.getIdentifier(request);
        RequestRecorder recorder = this.registry.recorderOf(name);
        return recorder.getRequest();
    }

    @Override
    public final void writeToResponse(SessionContext context) {
        Request request = context.getRequest();
        HttpRequest recordedRequest = this.getRequiredRecordedRequest((HttpRequest)request);
        SessionContext newContext = new SessionContext(recordedRequest, context.getResponse());
        this.modifier.writeToResponse(newContext);
    }

    @Override
    protected final ResponseHandler doApply(MocoConfig config) {
        RecorderIdentifier appliedIdentifier = this.identifier.apply(config);
        ReplayModifier appliedModifier = this.modifier.apply(config);
        if (appliedIdentifier != this.identifier || appliedModifier != this.modifier) {
            RecorderConfigurations configurations = RecorderConfigurations.create((Iterable<RecorderConfig>)ImmutableList.of((Object)Moco.group(this.registry.getGroup()), (Object)appliedIdentifier, (Object)appliedModifier));
            return new DynamicReplayHandler(configurations);
        }
        return this;
    }
}

