/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.setting;

import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.MocoEvent;
import com.github.dreamhead.moco.MocoEventTrigger;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.ResponseSetting;
import com.github.dreamhead.moco.internal.BaseResponseSettingConfiguration;
import com.github.dreamhead.moco.internal.SessionContext;
import com.github.dreamhead.moco.setting.Setting;
import com.github.dreamhead.moco.util.Configs;

public abstract class BaseSetting<T extends ResponseSetting<T>>
extends BaseResponseSettingConfiguration<T>
implements Setting<T> {
    private final RequestMatcher matcher;

    protected abstract BaseSetting<T> createSetting(RequestMatcher var1);

    protected abstract RequestMatcher configMatcher(RequestMatcher var1, MocoConfig var2);

    protected BaseSetting(RequestMatcher matcher) {
        this.matcher = matcher;
    }

    @Override
    public final boolean match(Request request) {
        return this.matcher.match(request) && this.handler != null;
    }

    @Override
    public final void writeToResponse(SessionContext context) {
        this.handler.writeToResponse(context);
        this.fireCompleteEvent(context.getRequest());
    }

    private void fireCompleteEvent(Request request) {
        for (MocoEventTrigger eventTrigger : this.eventTriggers) {
            if (!eventTrigger.isFor(MocoEvent.COMPLETE)) continue;
            eventTrigger.fireEvent(request);
        }
    }

    @Override
    public final Setting<T> apply(MocoConfig config) {
        BaseSetting<T> setting = this.createSetting(this.configMatcher(this.matcher, config));
        setting.handler = Configs.configItem(this.handler, config);
        setting.eventTriggers = Configs.configItems(this.eventTriggers, config);
        return setting;
    }
}

