/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.websocket;

import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.Response;
import com.github.dreamhead.moco.WebSocketServer;
import com.github.dreamhead.moco.internal.BaseActualServer;
import com.github.dreamhead.moco.internal.SessionContext;
import com.github.dreamhead.moco.model.MessageContent;
import com.github.dreamhead.moco.monitor.QuietMonitor;
import com.github.dreamhead.moco.resource.Resource;
import com.github.dreamhead.moco.setting.Setting;
import com.github.dreamhead.moco.util.ByteBufs;
import com.github.dreamhead.moco.websocket.ChannelSessionGroup;
import com.github.dreamhead.moco.websocket.ContextSessionGroup;
import com.github.dreamhead.moco.websocket.DefaultWebsocketRequest;
import com.github.dreamhead.moco.websocket.DefaultWebsocketResponse;
import com.github.dreamhead.moco.websocket.PingPongSetting;
import com.github.dreamhead.moco.websocket.PongResponse;
import com.github.dreamhead.moco.websocket.WebsocketResponse;
import com.github.dreamhead.moco.websocket.WebsocketResponseSetting;
import com.github.dreamhead.moco.websocket.WebsocketSetting;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class ActualWebSocketServer
extends BaseActualServer<WebsocketResponseSetting, ActualWebSocketServer>
implements WebSocketServer {
    private Resource connected;
    private ChannelSessionGroup group;
    private final String uri;
    private List<PingPongSetting> settings;

    public ActualWebSocketServer(String uri) {
        super(0, new QuietMonitor(), new MocoConfig[0]);
        this.uri = uri;
        this.group = new ChannelSessionGroup((ChannelGroup)new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE));
        this.settings = new ArrayList<PingPongSetting>();
    }

    @Override
    public void connected(Resource resource) {
        Preconditions.checkArgument((this.connected == null ? 1 : 0) != 0, (Object)"Only one connected can be setup");
        this.connected = (Resource)Preconditions.checkNotNull((Object)resource, (Object)"Connected resource should not be null");
    }

    @Override
    public void connected(String text) {
        Preconditions.checkArgument((this.connected == null ? 1 : 0) != 0, (Object)"Only one connected can be setup");
        this.connected(Moco.text((String)Preconditions.checkNotNull((Object)text, (Object)"Connected text should not be null")));
    }

    @Override
    public PongResponse ping(String message) {
        return this.ping(Moco.text(com.github.dreamhead.moco.util.Preconditions.checkNotNullOrEmpty(message, "Ping message should not be null")));
    }

    @Override
    public PongResponse ping(Resource message) {
        Resource resource = (Resource)Preconditions.checkNotNull((Object)message, (Object)"Ping message should not be null");
        return this.ping(Moco.by(resource));
    }

    @Override
    public PongResponse ping(RequestMatcher matcher) {
        RequestMatcher actual = (RequestMatcher)Preconditions.checkNotNull((Object)matcher, (Object)"Ping message should not be null");
        PingPongSetting setting = new PingPongSetting(actual);
        this.settings.add(setting);
        return setting;
    }

    private void connect(Channel channel) {
        this.group.add(channel);
    }

    public void disconnect(Channel channel) {
        this.group.remove(channel);
    }

    public String getUri() {
        return this.uri;
    }

    private void sendConnected(Channel channel) {
        if (this.connected != null) {
            MessageContent messageContent = this.connected.readFor(null);
            ByteBuf byteBuf = ByteBufs.toByteBuf(messageContent.getContent());
            channel.writeAndFlush((Object)new BinaryWebSocketFrame(byteBuf));
        }
    }

    public void connectRequest(ChannelHandlerContext ctx, FullHttpRequest request) {
        QueryStringDecoder decoder = new QueryStringDecoder(request.uri());
        String actual = decoder.path();
        if (!this.uri.equals(actual)) {
            ctx.writeAndFlush((Object)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
            return;
        }
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.uri, null, false);
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker((HttpRequest)request);
        Channel channel = ctx.channel();
        if (handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)channel);
            return;
        }
        handshaker.handshake(channel, request);
        this.connect(channel);
        this.sendConnected(channel);
    }

    @Override
    protected Setting<WebsocketResponseSetting> newSetting(RequestMatcher matcher) {
        return new WebsocketSetting(matcher);
    }

    @Override
    protected void addExtension(ActualWebSocketServer server) {
    }

    @Override
    protected ActualWebSocketServer createMergeServer(ActualWebSocketServer thatServer) {
        return new ActualWebSocketServer(this.uri);
    }

    @Override
    protected WebsocketResponseSetting onRequestAttached(RequestMatcher matcher) {
        WebsocketSetting baseSetting = new WebsocketSetting(matcher);
        this.addSetting(baseSetting);
        return baseSetting;
    }

    public PongWebSocketFrame handlePingPong(PingWebSocketFrame frame) {
        DefaultWebsocketRequest request = new DefaultWebsocketRequest((WebSocketFrame)frame);
        DefaultWebsocketResponse response = new DefaultWebsocketResponse();
        SessionContext context = new SessionContext(request, response);
        Response result = this.getPongResponse(context).orElseThrow(IllegalArgumentException::new);
        ByteBuf buf = ByteBufs.toByteBuf(result.getContent().getContent());
        return new PongWebSocketFrame(buf);
    }

    private Optional<Response> getPongResponse(SessionContext context) {
        Request request = context.getRequest();
        for (PingPongSetting setting : this.settings) {
            if (!setting.match(request)) continue;
            setting.writeToResponse(context);
            return Optional.of(context.getResponse());
        }
        return Optional.empty();
    }

    public Optional<WebsocketResponse> handleRequest(ChannelHandlerContext ctx, WebSocketFrame message) {
        DefaultWebsocketRequest request = new DefaultWebsocketRequest(message);
        DefaultWebsocketResponse response = new DefaultWebsocketResponse();
        SessionContext context = new SessionContext(request, response, new ContextSessionGroup(this.group, ctx.channel()));
        return this.getResponse(context).flatMap(this::asWebsocketResponse);
    }

    private Optional<WebsocketResponse> asWebsocketResponse(Response response) {
        if (response.getContent() != null) {
            return Optional.of((WebsocketResponse)response);
        }
        return Optional.empty();
    }
}

