/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.contrib.apache.httpclient.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;

public class PemUtil {
    public static PrivateKey loadPrivateKey(String privateKey) {
        privateKey = privateKey.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\\s+", "");
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKey)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301RSA", e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("\u65e0\u6548\u7684\u5bc6\u94a5\u683c\u5f0f");
        }
    }

    public static PrivateKey loadPrivateKey(InputStream inputStream) {
        String privateKey;
        ByteArrayOutputStream os = new ByteArrayOutputStream(2048);
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = inputStream.read(buffer)) != -1) {
                os.write(buffer, 0, length);
            }
            privateKey = os.toString("UTF-8");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u5bc6\u94a5", e);
        }
        return PemUtil.loadPrivateKey(privateKey);
    }

    public static X509Certificate loadCertificate(InputStream inputStream) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(inputStream);
            cert.checkValidity();
            return cert;
        }
        catch (CertificateExpiredException e) {
            throw new RuntimeException("\u8bc1\u4e66\u5df2\u8fc7\u671f", e);
        }
        catch (CertificateNotYetValidException e) {
            throw new RuntimeException("\u8bc1\u4e66\u5c1a\u672a\u751f\u6548", e);
        }
        catch (CertificateException e) {
            throw new RuntimeException("\u65e0\u6548\u7684\u8bc1\u4e66", e);
        }
    }
}

