/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.connection.nio.ClientProtocolEncoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.util.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.util.ClientMessageEncoder;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.networking.ChannelOption;
import com.hazelcast.internal.networking.InboundHandler;
import com.hazelcast.internal.networking.OutboundHandler;
import com.hazelcast.nio.Connection;
import com.hazelcast.util.function.Consumer;

public class ClientPlainChannelInitializer
implements ChannelInitializer {
    private final boolean directBuffer;
    private final SocketOptions socketOptions;

    public ClientPlainChannelInitializer(SocketOptions socketOptions, boolean directBuffer) {
        this.socketOptions = socketOptions;
        this.directBuffer = directBuffer;
    }

    public void initChannel(Channel channel) {
        channel.options().setOption(ChannelOption.SO_SNDBUF, (Object)(1024 * this.socketOptions.getBufferSize())).setOption(ChannelOption.SO_RCVBUF, (Object)(1024 * this.socketOptions.getBufferSize())).setOption(ChannelOption.SO_REUSEADDR, (Object)this.socketOptions.isReuseAddress()).setOption(ChannelOption.SO_KEEPALIVE, (Object)this.socketOptions.isKeepAlive()).setOption(ChannelOption.SO_LINGER, (Object)this.socketOptions.getLingerSeconds()).setOption(ChannelOption.SO_TIMEOUT, (Object)0).setOption(ChannelOption.TCP_NODELAY, (Object)this.socketOptions.isTcpNoDelay()).setOption(ChannelOption.DIRECT_BUF, (Object)this.directBuffer);
        final ClientConnection connection = (ClientConnection)channel.attributeMap().get(ClientConnection.class);
        ClientMessageDecoder decoder = new ClientMessageDecoder((Connection)connection, (Consumer)new Consumer<ClientMessage>(){

            public void accept(ClientMessage message) {
                connection.handleClientMessage(message);
            }
        });
        channel.inboundPipeline().addLast(new InboundHandler[]{decoder});
        channel.outboundPipeline().addLast(new OutboundHandler[]{new ClientMessageEncoder()});
        channel.outboundPipeline().addLast(new OutboundHandler[]{new ClientProtocolEncoder()});
    }
}

