/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.ext.simulate;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.beetl.core.Context;
import org.beetl.core.Function;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.misc.ClassSearch;
import org.beetl.ext.simulate.JsonUtil;
import org.beetl.ext.simulate.SimulateException;
import org.beetl.ext.web.ParameterWrapper;
import org.beetl.ext.web.SessionWrapper;
import org.beetl.ext.web.WebVariable;

public class BaseSimulate {
    protected GroupTemplate gt;
    protected String base = null;
    protected JsonUtil jsonUtil;

    public BaseSimulate(GroupTemplate gt, JsonUtil jsonUtil, String base) {
        this.gt = gt;
        this.base = base;
        this.jsonUtil = jsonUtil;
        if (jsonUtil != null) {
            gt.registerFunctionPackage("jsonUtil", jsonUtil);
            gt.registerFunction("jsonBody", new ReuqestBodyFunction(jsonUtil));
        }
    }

    protected String getCommonValueFile(HttpServletRequest hq, HttpServletResponse response) {
        String common = this.base + "/common.var";
        if (this.gt.getResourceLoader().exist(common)) {
            return common;
        }
        return null;
    }

    protected void output(String result, HttpServletResponse response) {
        try {
            response.getWriter().print(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void setValue(String key, Object value, HttpServletRequest hq) {
        if (key.equals("session")) {
            HttpSession session = hq.getSession();
            Map map = (Map)value;
            for (String sessionKey : map.keySet()) {
                Object sessionValue = map.get(sessionKey);
                session.setAttribute(sessionKey, sessionValue);
            }
        } else {
            hq.setAttribute(key, value);
        }
    }

    protected Map getScriptParas(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration attrs = request.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attrName = (String)attrs.nextElement();
            map.put(attrName, request.getAttribute(attrName));
        }
        WebVariable webVariable = new WebVariable();
        webVariable.setRequest(request);
        webVariable.setResponse(response);
        webVariable.setSession(request.getSession());
        map.put("parameter", new ParameterWrapper(request));
        map.put("session", new SessionWrapper(request, webVariable.getSession()));
        map.put("servlet", webVariable);
        map.put("request", request);
        map.put("ctxPath", request.getContextPath());
        return map;
    }

    public String getValuePath(HttpServletRequest request) {
        return request.getServletPath();
    }

    protected RestPath getRealPath(String path, String method) {
        return this.getRealPath(this.gt.getResourceLoader(), path, method);
    }

    private RestPath getRealPath(ResourceLoader loader, String path, String method) {
        path = this.base + "/" + path;
        RestPath restPath = new RestPath();
        ArrayList<String> pathVars = new ArrayList<String>();
        String[] paths = path.split("/");
        String realPath = "";
        for (int i = 0; i < paths.length; ++i) {
            boolean exist;
            String temp;
            String p = paths[i];
            if (p.length() == 0 || p.equals("/")) continue;
            if (i != paths.length - 1) {
                temp = realPath + "/" + p;
                exist = loader.exist(temp);
                if (!exist) {
                    temp = realPath + "/$$";
                    exist = loader.exist(temp);
                    if (!exist) {
                        return null;
                    }
                    pathVars.add(p);
                    realPath = temp;
                    continue;
                }
                realPath = temp;
                continue;
            }
            temp = realPath + "/" + p + "." + method + ".var";
            exist = loader.exist(temp);
            if (exist) {
                realPath = temp;
                continue;
            }
            temp = realPath + "/" + p + ".var";
            exist = loader.exist(temp);
            if (exist) {
                realPath = temp;
                continue;
            }
            temp = realPath + "/$$." + method + ".var";
            if (loader.exist(temp)) {
                realPath = temp;
                pathVars.add(p);
                continue;
            }
            temp = realPath + "/$$" + ".var";
            if (loader.exist(temp)) {
                realPath = temp;
                pathVars.add(p);
                continue;
            }
            return null;
        }
        restPath.path = realPath;
        restPath.values = pathVars;
        return restPath;
    }

    public static class ReuqestBodyFunction
    implements Function {
        JsonUtil jsonUtil;

        public ReuqestBodyFunction(JsonUtil jsonUtil) {
            this.jsonUtil = jsonUtil;
        }

        @Override
        public Object call(Object[] paras, Context ctx) {
            String body;
            HttpServletRequest req = (HttpServletRequest)ctx.getGlobal("request");
            GroupTemplate gt = ctx.gt;
            String name = (String)paras[0];
            ClassSearch search = gt.getClassSearch();
            Class cls = search.getClassByName(name);
            try {
                body = this.getRequestBody(req.getReader());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (this.jsonUtil == null) {
                throw new SimulateException("\u6ca1\u6709\u8bbe\u7f6ejsonUtil\uff0c\u65e0\u6cd5\u5c06json\u8f6c\u4e3a\u5bf9\u8c61");
            }
            Object obj = this.jsonUtil.toObject(body, cls);
            return obj;
        }

        private String getRequestBody(BufferedReader reader) throws IOException {
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            return sb.toString();
        }
    }

    public static class RestPath {
        public String path;
        public List<String> values = new ArrayList<String>();
    }
}

