/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.tag;

import java.util.Collections;
import java.util.Map;
import org.beetl.core.Context;
import org.beetl.core.Template;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.statement.Statement;
import org.beetl.core.tag.Tag;
import org.beetl.core.tag.TagFactory;

public class HTMLTagSupportWrapper
extends Tag {
    protected String tagRoot = null;
    protected String tagSuffix = null;

    @Override
    public void init(Context ctx, Object[] args, Statement st) {
        super.inintBase(ctx, args, st);
        this.tagRoot = ctx.gt.getConf().getResourceMap().get("tagRoot");
        this.tagSuffix = ctx.gt.getConf().getResourceMap().get("tagSuffix");
    }

    @Override
    public void render() {
        if (this.args.length == 0 || this.args.length > 2) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff0c\u671f\u671bchild,Map .....");
        }
        String child = (String)this.args[0];
        TagFactory tagFactory = null;
        String functionTagName = child.replace(':', '.');
        tagFactory = this.gt.getTagFactory(functionTagName);
        if (tagFactory == null) {
            String path = this.getHtmlTagResourceId(child);
            this.callHtmlTag(path);
        } else {
            this.callTag(tagFactory);
        }
    }

    protected String getHtmlTagResourceId(String child) {
        String path = child.replace(':', '/');
        StringBuilder sb = new StringBuilder("/");
        sb.append(this.tagRoot).append("/").append(path).append(".").append(this.tagSuffix);
        return sb.toString();
    }

    protected void callTag(TagFactory tagFactory) {
        Tag tag = tagFactory.createTag();
        tag.init(this.ctx, this.args, this.bs);
        tag.render();
        tag.afterRender();
    }

    public Map getAttrs() {
        if (this.args.length == 1) {
            return Collections.emptyMap();
        }
        return (Map)this.args[1];
    }

    protected void callHtmlTag(String path) {
        Template t = null;
        t = this.gt.getTemplate(path, this.ctx);
        t.binding(this.ctx.globalVar);
        t.getCtx().setCurrentTag(this.ctx.getCurrentTag());
        if (this.args.length == 2) {
            Map map = (Map)this.args[1];
            for (Map.Entry entry : map.entrySet()) {
                t.binding((String)entry.getKey(), entry.getValue());
            }
        }
        t.binding("tagBody", new Object(){

            public String toString() {
                try {
                    return HTMLTagSupportWrapper.super.getBodyContent().toString();
                }
                catch (BeetlException ex) {
                    ex.inTagBody = true;
                    throw ex;
                }
            }
        });
        t.renderTo(this.ctx.byteWriter);
    }
}

