/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.client.InfluxDBClientOptions;
import com.influxdb.client.domain.WritePrecision;
import com.influxdb.client.internal.AbstractWriteClient;
import com.influxdb.client.internal.MeasurementMapper;
import com.influxdb.client.service.WriteService;
import com.influxdb.internal.AbstractRestClient;
import com.influxdb.utils.Arguments;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import retrofit2.Call;

public abstract class AbstractWriteBlockingClient
extends AbstractRestClient {
    private static final Logger LOG = Logger.getLogger(AbstractWriteBlockingClient.class.getName());
    private final WriteService service;
    private final MeasurementMapper measurementMapper = new MeasurementMapper();
    protected final InfluxDBClientOptions options;

    public AbstractWriteBlockingClient(@Nonnull WriteService service, @Nonnull InfluxDBClientOptions options) {
        Arguments.checkNotNull((Object)service, (String)"service");
        Arguments.checkNotNull((Object)options, (String)"options");
        this.options = options;
        this.service = service;
    }

    protected void write(@Nonnull String bucket, @Nonnull String organization, @Nonnull WritePrecision precision, @Nonnull Stream<AbstractWriteClient.BatchWriteData> stream) {
        String lineProtocol = stream.map(AbstractWriteClient.BatchWriteData::toLineProtocol).filter(it -> it != null && !it.isEmpty()).collect(Collectors.joining("\n"));
        if (lineProtocol.isEmpty()) {
            LOG.warning("The writes: " + stream + " doesn't contains any Line Protocol, skipping");
            return;
        }
        LOG.log(Level.FINEST, "Writing time-series data into InfluxDB (org={0}, bucket={1}, precision={2})...", new Object[]{organization, bucket, precision});
        Call<Void> voidCall = this.service.postWrite(organization, bucket, lineProtocol, null, "identity", "text/plain; charset=utf-8", null, "application/json", null, precision);
        this.execute(voidCall);
        LOG.log(Level.FINEST, "Written data into InfluxDB: {0}", lineProtocol);
    }

    @Nonnull
    protected <M> AbstractWriteClient.BatchWriteDataMeasurement toMeasurementBatch(@Nullable M measurement, @Nonnull WritePrecision precision) {
        Arguments.checkNotNull((Object)((Object)precision), (String)"WritePrecision");
        return new AbstractWriteClient.BatchWriteDataMeasurement(measurement, precision, this.options, this.measurementMapper);
    }
}

