/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.css.impl;

import com.itextpdf.io.util.DecimalFormatUtil;
import com.itextpdf.io.util.ResourceUtil;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.CssFontFaceRule;
import com.itextpdf.styledxmlparser.css.CssStatement;
import com.itextpdf.styledxmlparser.css.CssStyleSheet;
import com.itextpdf.styledxmlparser.css.ICssResolver;
import com.itextpdf.styledxmlparser.css.media.CssMediaRule;
import com.itextpdf.styledxmlparser.css.media.MediaDeviceDescription;
import com.itextpdf.styledxmlparser.css.parse.CssRuleSetParser;
import com.itextpdf.styledxmlparser.css.parse.CssStyleSheetParser;
import com.itextpdf.styledxmlparser.css.resolve.AbstractCssContext;
import com.itextpdf.styledxmlparser.css.resolve.CssDefaults;
import com.itextpdf.styledxmlparser.css.resolve.CssInheritance;
import com.itextpdf.styledxmlparser.css.resolve.IStyleInheritance;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.styledxmlparser.node.IAttribute;
import com.itextpdf.styledxmlparser.node.IDataNode;
import com.itextpdf.styledxmlparser.node.IDocumentNode;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.INode;
import com.itextpdf.styledxmlparser.node.IStylesContainer;
import com.itextpdf.styledxmlparser.node.ITextNode;
import com.itextpdf.styledxmlparser.resolver.resource.ResourceResolver;
import com.itextpdf.styledxmlparser.util.StyleUtil;
import com.itextpdf.svg.SvgConstants;
import com.itextpdf.svg.css.SvgCssContext;
import com.itextpdf.svg.css.impl.SvgAttributeInheritance;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.processors.impl.SvgConverterProperties;
import com.itextpdf.svg.processors.impl.SvgProcessorContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SvgStyleResolver
implements ICssResolver {
    public static final Set<IStyleInheritance> INHERITANCE_RULES = Collections.unmodifiableSet(new HashSet<IStyleInheritance>(Arrays.asList(new CssInheritance(), new SvgAttributeInheritance())));
    private static final String[] ELEMENTS_INHERITING_PARENT_STYLES = new String[]{"marker", SvgConstants.Tags.LINEAR_GRADIENT, "pattern"};
    private static final float DEFAULT_FONT_SIZE = CssDimensionParsingUtils.parseAbsoluteFontSize((String)CssDefaults.getDefaultValue((String)"font-size"));
    private static final Logger LOGGER = LoggerFactory.getLogger(SvgStyleResolver.class);
    private CssStyleSheet css;
    private static final String DEFAULT_CSS_PATH = "com/itextpdf/svg/default.css";
    private boolean isFirstSvgElement = true;
    private MediaDeviceDescription deviceDescription;
    private final List<CssFontFaceRule> fonts = new ArrayList<CssFontFaceRule>();
    private final ResourceResolver resourceResolver;

    @Deprecated
    public SvgStyleResolver(InputStream defaultCssStream) throws IOException {
        this(defaultCssStream, new SvgProcessorContext(new SvgConverterProperties()));
    }

    @Deprecated
    public SvgStyleResolver() {
        this(new SvgProcessorContext(new SvgConverterProperties()));
    }

    public SvgStyleResolver(InputStream defaultCssStream, SvgProcessorContext context) throws IOException {
        this.css = CssStyleSheetParser.parse((InputStream)defaultCssStream);
        this.resourceResolver = context.getResourceResolver();
    }

    public SvgStyleResolver(SvgProcessorContext context) {
        try (InputStream defaultCss = ResourceUtil.getResourceStream((String)DEFAULT_CSS_PATH);){
            this.css = CssStyleSheetParser.parse((InputStream)defaultCss);
        }
        catch (IOException e) {
            LOGGER.warn("Error loading the default CSS. Initializing an empty style sheet.", (Throwable)e);
            this.css = new CssStyleSheet();
        }
        this.resourceResolver = context.getResourceResolver();
    }

    public SvgStyleResolver(INode rootNode, SvgProcessorContext context) {
        this.deviceDescription = context.getDeviceDescription();
        this.resourceResolver = context.getResourceResolver();
        this.collectCssDeclarations(rootNode, this.resourceResolver);
        this.collectFonts();
    }

    public static void resolveFontSizeStyle(Map<String, String> styles, SvgCssContext cssContext, String parentFontSizeStr) {
        String resolvedFontSize;
        String elementFontSize = styles.get("font-size");
        if (CssTypesValidationUtils.isNegativeValue((String)elementFontSize)) {
            elementFontSize = parentFontSizeStr;
        }
        if (CssTypesValidationUtils.isRelativeValue((String)elementFontSize) || "larger".equals(elementFontSize) || "smaller".equals(elementFontSize)) {
            float baseFontSize = CssTypesValidationUtils.isRemValue((String)elementFontSize) ? (cssContext == null ? DEFAULT_FONT_SIZE : cssContext.getRootFontSize()) : (parentFontSizeStr == null ? CssDimensionParsingUtils.parseAbsoluteFontSize((String)CssDefaults.getDefaultValue((String)"font-size")) : CssDimensionParsingUtils.parseAbsoluteLength((String)parentFontSizeStr));
            float absoluteFontSize = CssDimensionParsingUtils.parseRelativeFontSize((String)elementFontSize, (float)baseFontSize);
            resolvedFontSize = DecimalFormatUtil.formatNumber((double)absoluteFontSize, (String)"0.####");
        } else {
            resolvedFontSize = elementFontSize == null ? DecimalFormatUtil.formatNumber((double)DEFAULT_FONT_SIZE, (String)"0.####") : DecimalFormatUtil.formatNumber((double)CssDimensionParsingUtils.parseAbsoluteFontSize((String)elementFontSize), (String)"0.####");
        }
        styles.put("font-size", resolvedFontSize + "pt");
    }

    public static boolean isElementNested(IElementNode element, String parentElementNameForSearch) {
        if (!(element.parentNode() instanceof IElementNode)) {
            return false;
        }
        IElementNode parentElement = (IElementNode)element.parentNode();
        if (parentElement == null) {
            return false;
        }
        if (parentElement.name() != null && parentElement.name().equals(parentElementNameForSearch)) {
            return true;
        }
        return SvgStyleResolver.isElementNested(parentElement, parentElementNameForSearch);
    }

    public Map<String, String> resolveStyles(INode element, AbstractCssContext context) {
        if (context instanceof SvgCssContext) {
            return this.resolveStyles(element, (SvgCssContext)context);
        }
        throw new SvgProcessingException("Custom AbstractCssContext implementations are not supported yet");
    }

    public Map<String, String> resolveNativeStyles(INode node, AbstractCssContext cssContext) {
        HashMap<String, String> styles = new HashMap<String, String>();
        List styleSheetDeclarations = this.css.getCssDeclarations(node, MediaDeviceDescription.createDefault());
        for (CssDeclaration ssd : styleSheetDeclarations) {
            styles.put(ssd.getProperty(), ssd.getExpression());
        }
        if (node instanceof IElementNode) {
            IElementNode eNode = (IElementNode)node;
            for (IAttribute attr : eNode.getAttributes()) {
                this.processAttribute(attr, styles);
            }
        }
        return styles;
    }

    private static boolean onlyNativeStylesShouldBeResolved(IElementNode element) {
        for (String elementInheritingParentStyles : ELEMENTS_INHERITING_PARENT_STYLES) {
            if (!elementInheritingParentStyles.equals(element.name()) && !SvgStyleResolver.isElementNested(element, elementInheritingParentStyles)) continue;
            return false;
        }
        return SvgStyleResolver.isElementNested(element, "defs");
    }

    private Map<String, String> resolveStyles(INode element, SvgCssContext context) {
        boolean isSvgElement;
        Map styles = this.resolveNativeStyles(element, context);
        if (element instanceof IElementNode && SvgStyleResolver.onlyNativeStylesShouldBeResolved((IElementNode)element)) {
            return styles;
        }
        String parentFontSizeStr = null;
        if (element.parentNode() instanceof IStylesContainer) {
            IStylesContainer parentNode = (IStylesContainer)element.parentNode();
            Map parentStyles = parentNode.getStyles();
            if (parentStyles == null && !(parentNode instanceof IDocumentNode)) {
                LOGGER.error("Element parent styles are not resolved. Styles for current element might be incorrect.");
            }
            if (parentStyles != null) {
                parentFontSizeStr = (String)parentStyles.get("font-size");
                for (Map.Entry entry : parentStyles.entrySet()) {
                    styles = StyleUtil.mergeParentStyleDeclaration(styles, (String)((String)entry.getKey()), (String)((String)entry.getValue()), (String)parentFontSizeStr, INHERITANCE_RULES);
                }
            }
        }
        SvgStyleResolver.resolveFontSizeStyle(styles, context, parentFontSizeStr);
        boolean bl = isSvgElement = element instanceof IElementNode && "svg".equals(((IElementNode)element).name());
        if (this.isFirstSvgElement && isSvgElement) {
            this.isFirstSvgElement = false;
            String rootFontSize = styles.get("font-size");
            if (rootFontSize != null) {
                context.setRootFontSize(styles.get("font-size"));
            }
        }
        return styles;
    }

    private void processXLink(IAttribute attr, Map<String, String> attributesMap) {
        String xlinkValue = attr.getValue();
        if (!this.isStartedWithHash(xlinkValue) && !new ResourceResolver("").isDataSrc(xlinkValue)) {
            try {
                xlinkValue = this.resourceResolver.resolveAgainstBaseUri(attr.getValue()).toExternalForm();
            }
            catch (MalformedURLException mue) {
                LOGGER.error("Unable to resolve image path with given base URI ({0}) and image source path ({1})", (Throwable)mue);
            }
        }
        attributesMap.put(attr.getKey(), xlinkValue);
    }

    private boolean isStartedWithHash(String s) {
        return s != null && s.startsWith("#");
    }

    private void collectCssDeclarations(INode rootNode, ResourceResolver resourceResolver) {
        this.css = new CssStyleSheet();
        LinkedList<INode> q = new LinkedList<INode>();
        if (rootNode != null) {
            q.add(rootNode);
        }
        while (!q.isEmpty()) {
            INode currentNode = (INode)q.pop();
            if (currentNode instanceof IElementNode) {
                IElementNode headChildElement = (IElementNode)currentNode;
                if ("style".equals(headChildElement.name())) {
                    if (!currentNode.childNodes().isEmpty() && (currentNode.childNodes().get(0) instanceof IDataNode || currentNode.childNodes().get(0) instanceof ITextNode)) {
                        String styleData = currentNode.childNodes().get(0) instanceof IDataNode ? ((IDataNode)currentNode.childNodes().get(0)).getWholeData() : ((ITextNode)currentNode.childNodes().get(0)).wholeText();
                        CssStyleSheet styleSheet = CssStyleSheetParser.parse((String)styleData);
                        this.css.appendCssStyleSheet(styleSheet);
                    }
                } else if (CssUtils.isStyleSheetLink((IElementNode)headChildElement)) {
                    String styleSheetUri = headChildElement.getAttribute("href");
                    try (InputStream stream = resourceResolver.retrieveResourceAsInputStream(styleSheetUri);){
                        if (stream != null) {
                            CssStyleSheet styleSheet = CssStyleSheetParser.parse((InputStream)stream, (String)resourceResolver.resolveAgainstBaseUri(styleSheetUri).toExternalForm());
                            this.css.appendCssStyleSheet(styleSheet);
                        }
                    }
                    catch (Exception exc) {
                        LOGGER.error("Unable to process external css file", (Throwable)exc);
                    }
                }
            }
            for (INode child : currentNode.childNodes()) {
                if (!(child instanceof IElementNode)) continue;
                q.add(child);
            }
        }
    }

    public List<CssFontFaceRule> getFonts() {
        return new ArrayList<CssFontFaceRule>(this.fonts);
    }

    private void collectFonts() {
        for (CssStatement cssStatement : this.css.getStatements()) {
            this.collectFonts(cssStatement);
        }
    }

    private void collectFonts(CssStatement cssStatement) {
        if (cssStatement instanceof CssFontFaceRule) {
            this.fonts.add((CssFontFaceRule)cssStatement);
        } else if (cssStatement instanceof CssMediaRule && ((CssMediaRule)cssStatement).matchMediaDevice(this.deviceDescription)) {
            for (CssStatement cssSubStatement : ((CssMediaRule)cssStatement).getStatements()) {
                this.collectFonts(cssSubStatement);
            }
        }
    }

    private void processAttribute(IAttribute attr, Map<String, String> styles) {
        switch (attr.getKey()) {
            case "style": {
                Map<String, String> parsed = this.parseStylesFromStyleAttribute(attr.getValue());
                for (Map.Entry<String, String> style : parsed.entrySet()) {
                    styles.put(style.getKey(), style.getValue());
                }
                break;
            }
            case "xlink:href": {
                this.processXLink(attr, styles);
                break;
            }
            default: {
                styles.put(attr.getKey(), attr.getValue());
            }
        }
    }

    private Map<String, String> parseStylesFromStyleAttribute(String style) {
        HashMap<String, String> parsed = new HashMap<String, String>();
        List declarations = CssRuleSetParser.parsePropertyDeclarations((String)style);
        for (CssDeclaration declaration : declarations) {
            parsed.put(declaration.getProperty(), declaration.getExpression());
        }
        return parsed;
    }
}

