/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.graphic.RtfImage;
import com.lowagie.text.rtf.style.RtfFont;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import com.lowagie.text.rtf.text.RtfPhrase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfParagraph
extends RtfPhrase {
    public static final byte[] PARAGRAPH = "\\par".getBytes();
    private RtfParagraphStyle paragraphStyle = null;

    public RtfParagraph(RtfDocument rtfDocument, Paragraph paragraph) {
        super(rtfDocument);
        RtfFont rtfFont = null;
        if (paragraph.font() instanceof RtfParagraphStyle) {
            this.paragraphStyle = this.document.getDocumentHeader().getRtfParagraphStyle(((RtfParagraphStyle)paragraph.font()).getStyleName());
            rtfFont = this.paragraphStyle;
        } else {
            rtfFont = new RtfFont(this.document, paragraph.font());
            this.paragraphStyle = new RtfParagraphStyle(this.document, this.document.getDocumentHeader().getRtfParagraphStyle("Normal"));
            this.paragraphStyle.setAlignment(paragraph.alignment());
            this.paragraphStyle.setIndentLeft((int)((double)paragraph.indentationLeft() * 20.0));
            this.paragraphStyle.setIndentRight((int)((double)paragraph.indentationRight() * 20.0));
            this.paragraphStyle.setSpacingBefore((int)((double)paragraph.spacingBefore() * 20.0));
            this.paragraphStyle.setSpacingAfter((int)((double)paragraph.spacingAfter() * 20.0));
            if (paragraph.leadingDefined()) {
                this.paragraphStyle.setLineLeading((int)((double)paragraph.leading() * 20.0));
            }
            this.paragraphStyle.setKeepTogether(paragraph.getKeepTogether());
        }
        for (int i = 0; i < paragraph.size(); ++i) {
            Element element = (Element)paragraph.get(i);
            if (element instanceof Chunk) {
                ((Chunk)element).setFont(rtfFont.difference(((Chunk)element).font()));
            } else if (element instanceof RtfImage) {
                ((RtfImage)this.chunks.get(i)).setAlignment(this.paragraphStyle.getAlignment());
            }
            try {
                this.chunks.add(rtfDocument.getMapper().mapElement(element));
                continue;
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
        }
    }

    public void setKeepTogetherWithNext(boolean bl) {
        this.paragraphStyle.setKeepTogetherWithNext(bl);
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(PARAGRAPH_DEFAULTS);
            if (this.inTable) {
                byteArrayOutputStream.write(IN_TABLE);
            }
            if (this.paragraphStyle != null) {
                byteArrayOutputStream.write(this.paragraphStyle.writeBegin());
            }
            for (int i = 0; i < this.chunks.size(); ++i) {
                byteArrayOutputStream.write(((RtfBasicElement)this.chunks.get(i)).write());
            }
            if (this.paragraphStyle != null) {
                byteArrayOutputStream.write(this.paragraphStyle.writeEnd());
            }
            if (!this.inTable) {
                byteArrayOutputStream.write(PARAGRAPH);
            }
            if (this.document.getDocumentSettings().isOutputDebugLineBreaks()) {
                byteArrayOutputStream.write(10);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public int getIndentLeft() {
        return this.paragraphStyle.getIndentLeft();
    }

    public void setIndentLeft(int n) {
        this.paragraphStyle.setIndentLeft(n);
    }

    public int getIndentRight() {
        return this.paragraphStyle.getIndentRight();
    }

    public void setIndentRight(int n) {
        this.paragraphStyle.setIndentRight(n);
    }
}

