/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.impl;

import com.netflix.spectator.impl.Preconditions;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.util.Arrays;

public final class AsciiSet {
    private static final MethodHandle STRING_CONSTRUCTOR;
    private final String pattern;
    private final boolean[] members;

    private static boolean isJava8() {
        String version = System.getProperty("java.version", "1.8");
        return version.startsWith("1.8");
    }

    private static String newString(char[] buf) {
        if (STRING_CONSTRUCTOR != null) {
            try {
                return STRING_CONSTRUCTOR.invokeExact(buf, true);
            }
            catch (Throwable t) {
                return new String(buf);
            }
        }
        return new String(buf);
    }

    public static AsciiSet fromPattern(String pattern) {
        boolean[] members = new boolean[128];
        int n = pattern.length();
        for (int i = 0; i < n; ++i) {
            boolean isStartOrEnd;
            char c = pattern.charAt(i);
            if (c >= members.length) {
                throw new IllegalArgumentException("invalid pattern, '" + c + "' is not ascii");
            }
            boolean bl = isStartOrEnd = i == 0 || i == n - 1;
            if (isStartOrEnd || c != '-') {
                members[c] = true;
                continue;
            }
            char s = pattern.charAt(i - 1);
            char e = pattern.charAt(i + 1);
            for (char v = s; v <= e; v = (char)(v + '\u0001')) {
                members[v] = true;
            }
        }
        return new AsciiSet(members);
    }

    private static String toPattern(boolean[] members) {
        StringBuilder buf = new StringBuilder();
        boolean previous = false;
        char s = '\u0000';
        for (int i = 0; i < members.length; ++i) {
            if (members[i] && !previous) {
                s = (char)i;
            } else if (!members[i] && previous) {
                char e = (char)(i - 1);
                AsciiSet.append(buf, s, e);
            }
            previous = members[i];
        }
        if (previous) {
            char e = (char)(members.length - 1);
            AsciiSet.append(buf, s, e);
        }
        return buf.toString();
    }

    private static void append(StringBuilder buf, char s, char e) {
        switch (e - s) {
            case 0: {
                buf.append(s);
                break;
            }
            case 1: {
                buf.append(s).append(e);
                break;
            }
            default: {
                buf.append(s).append('-').append(e);
            }
        }
    }

    private AsciiSet(boolean[] members) {
        this.members = Preconditions.checkNotNull(members, "members array cannot be null");
        this.pattern = AsciiSet.toPattern(members);
    }

    public boolean contains(char c) {
        return c < '\u0080' && this.members[c];
    }

    public boolean containsAll(CharSequence str) {
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            if (this.contains(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public String replaceNonMembers(String input, char replacement) {
        if (!this.contains(replacement)) {
            throw new IllegalArgumentException(replacement + " is not a member of " + this.pattern);
        }
        return this.containsAll(input) ? input : this.replaceNonMembersImpl(input, replacement);
    }

    private String replaceNonMembersImpl(String input, char replacement) {
        int n = input.length();
        char[] buf = input.toCharArray();
        for (int i = 0; i < n; ++i) {
            char c = buf[i];
            if (this.contains(c)) continue;
            buf[i] = replacement;
        }
        return AsciiSet.newString(buf);
    }

    public String toString() {
        return this.pattern;
    }

    public int hashCode() {
        return this.pattern.hashCode() + 31 * Arrays.hashCode(this.members);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof AsciiSet)) {
            return false;
        }
        AsciiSet other = (AsciiSet)obj;
        return this.pattern.equals(other.pattern) && Arrays.equals(this.members, other.members);
    }

    static {
        if (AsciiSet.isJava8()) {
            MethodHandle handle;
            try {
                Constructor ctor = String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
                ctor.setAccessible(true);
                handle = MethodHandles.lookup().unreflectConstructor(ctor);
            }
            catch (Exception e) {
                handle = null;
            }
            STRING_CONSTRUCTOR = handle;
        } else {
            STRING_CONSTRUCTOR = null;
        }
    }
}

