/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.dnsoverhttps;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nullable;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dns;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.dnsoverhttps.BootstrapDns;
import okhttp3.dnsoverhttps.DnsRecordCodec;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.publicsuffix.PublicSuffixDatabase;
import okio.ByteString;

public class DnsOverHttps
implements Dns {
    public static final MediaType DNS_MESSAGE = MediaType.get((String)"application/dns-message");
    public static final int MAX_RESPONSE_SIZE = 65536;
    private final OkHttpClient client;
    private final HttpUrl url;
    private final boolean includeIPv6;
    private final boolean post;
    private final boolean resolvePrivateAddresses;
    private final boolean resolvePublicAddresses;

    DnsOverHttps(Builder builder) {
        if (builder.client == null) {
            throw new NullPointerException("client not set");
        }
        if (builder.url == null) {
            throw new NullPointerException("url not set");
        }
        this.url = builder.url;
        this.includeIPv6 = builder.includeIPv6;
        this.post = builder.post;
        this.resolvePrivateAddresses = builder.resolvePrivateAddresses;
        this.resolvePublicAddresses = builder.resolvePublicAddresses;
        this.client = builder.client.newBuilder().dns(DnsOverHttps.buildBootstrapClient(builder)).build();
    }

    private static Dns buildBootstrapClient(Builder builder) {
        List<InetAddress> hosts = builder.bootstrapDnsHosts;
        if (hosts != null) {
            return new BootstrapDns(builder.url.host(), hosts);
        }
        return builder.systemDns;
    }

    public HttpUrl url() {
        return this.url;
    }

    public boolean post() {
        return this.post;
    }

    public boolean includeIPv6() {
        return this.includeIPv6;
    }

    public OkHttpClient client() {
        return this.client;
    }

    public boolean resolvePrivateAddresses() {
        return this.resolvePrivateAddresses;
    }

    public boolean resolvePublicAddresses() {
        return this.resolvePublicAddresses;
    }

    public List<InetAddress> lookup(String hostname) throws UnknownHostException {
        if (!this.resolvePrivateAddresses || !this.resolvePublicAddresses) {
            boolean privateHost = DnsOverHttps.isPrivateHost(hostname);
            if (privateHost && !this.resolvePrivateAddresses) {
                throw new UnknownHostException("private hosts not resolved");
            }
            if (!privateHost && !this.resolvePublicAddresses) {
                throw new UnknownHostException("public hosts not resolved");
            }
        }
        return this.lookupHttps(hostname);
    }

    private List<InetAddress> lookupHttps(String hostname) throws UnknownHostException {
        ArrayList<Call> networkRequests = new ArrayList<Call>(2);
        ArrayList<Exception> failures = new ArrayList<Exception>(2);
        ArrayList<InetAddress> results = new ArrayList<InetAddress>(5);
        this.buildRequest(hostname, networkRequests, results, failures, 1);
        if (this.includeIPv6) {
            this.buildRequest(hostname, networkRequests, results, failures, 28);
        }
        this.executeRequests(hostname, networkRequests, results, failures);
        if (!results.isEmpty()) {
            return results;
        }
        return this.throwBestFailure(hostname, failures);
    }

    private void buildRequest(String hostname, List<Call> networkRequests, List<InetAddress> results, List<Exception> failures, int type) {
        Request request = this.buildRequest(hostname, type);
        Response response = this.getCacheOnlyResponse(request);
        if (response != null) {
            this.processResponse(response, hostname, results, failures);
        } else {
            networkRequests.add(this.client.newCall(request));
        }
    }

    private void executeRequests(final String hostname, List<Call> networkRequests, final List<InetAddress> responses, final List<Exception> failures) {
        final CountDownLatch latch = new CountDownLatch(networkRequests.size());
        for (Call call : networkRequests) {
            call.enqueue(new Callback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFailure(Call call, IOException e) {
                    List list = failures;
                    synchronized (list) {
                        failures.add(e);
                    }
                    latch.countDown();
                }

                public void onResponse(Call call, Response response) {
                    DnsOverHttps.this.processResponse(response, hostname, responses, failures);
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            failures.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponse(Response response, String hostname, List<InetAddress> results, List<Exception> failures) {
        try {
            List<InetAddress> addresses = this.readResponse(hostname, response);
            List<InetAddress> list = results;
            synchronized (list) {
                results.addAll(addresses);
            }
        }
        catch (Exception e) {
            List<Exception> list = failures;
            synchronized (list) {
                failures.add(e);
            }
        }
    }

    private List<InetAddress> throwBestFailure(String hostname, List<Exception> failures) throws UnknownHostException {
        if (failures.size() == 0) {
            throw new UnknownHostException(hostname);
        }
        Exception failure = failures.get(0);
        if (failure instanceof UnknownHostException) {
            throw (UnknownHostException)failure;
        }
        UnknownHostException unknownHostException = new UnknownHostException(hostname);
        unknownHostException.initCause(failure);
        for (int i = 1; i < failures.size(); ++i) {
            Util.addSuppressedIfPossible((Throwable)unknownHostException, (Throwable)failures.get(i));
        }
        throw unknownHostException;
    }

    @Nullable
    private Response getCacheOnlyResponse(Request request) {
        if (!this.post && this.client.cache() != null) {
            try {
                Request cacheRequest = request.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
                Response cacheResponse = this.client.newCall(cacheRequest).execute();
                if (cacheResponse.code() != 504) {
                    return cacheResponse;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InetAddress> readResponse(String hostname, Response response) throws Exception {
        if (response.cacheResponse() == null && response.protocol() != Protocol.HTTP_2) {
            Platform.get().log(5, "Incorrect protocol: " + response.protocol(), null);
        }
        try {
            if (!response.isSuccessful()) {
                throw new IOException("response: " + response.code() + " " + response.message());
            }
            ResponseBody body = response.body();
            if (body.contentLength() > 65536L) {
                throw new IOException("response size exceeds limit (65536 bytes): " + body.contentLength() + " bytes");
            }
            ByteString responseBytes = body.source().readByteString();
            List<InetAddress> list = DnsRecordCodec.decodeAnswers(hostname, responseBytes);
            return list;
        }
        finally {
            response.close();
        }
    }

    private Request buildRequest(String hostname, int type) {
        Request.Builder requestBuilder = new Request.Builder().header("Accept", DNS_MESSAGE.toString());
        ByteString query = DnsRecordCodec.encodeQuery(hostname, type);
        if (this.post) {
            requestBuilder = requestBuilder.url(this.url).post(RequestBody.create((MediaType)DNS_MESSAGE, (ByteString)query));
        } else {
            String encoded = query.base64Url().replace("=", "");
            HttpUrl requestUrl = this.url.newBuilder().addQueryParameter("dns", encoded).build();
            requestBuilder = requestBuilder.url(requestUrl);
        }
        return requestBuilder.build();
    }

    static boolean isPrivateHost(String host) {
        return PublicSuffixDatabase.get().getEffectiveTldPlusOne(host) == null;
    }

    public static final class Builder {
        @Nullable
        OkHttpClient client = null;
        @Nullable
        HttpUrl url = null;
        boolean includeIPv6 = true;
        boolean post = false;
        Dns systemDns = Dns.SYSTEM;
        @Nullable
        List<InetAddress> bootstrapDnsHosts = null;
        boolean resolvePrivateAddresses = false;
        boolean resolvePublicAddresses = true;

        public DnsOverHttps build() {
            return new DnsOverHttps(this);
        }

        public Builder client(OkHttpClient client) {
            this.client = client;
            return this;
        }

        public Builder url(HttpUrl url) {
            this.url = url;
            return this;
        }

        public Builder includeIPv6(boolean includeIPv6) {
            this.includeIPv6 = includeIPv6;
            return this;
        }

        public Builder post(boolean post) {
            this.post = post;
            return this;
        }

        public Builder resolvePrivateAddresses(boolean resolvePrivateAddresses) {
            this.resolvePrivateAddresses = resolvePrivateAddresses;
            return this;
        }

        public Builder resolvePublicAddresses(boolean resolvePublicAddresses) {
            this.resolvePublicAddresses = resolvePublicAddresses;
            return this;
        }

        public Builder bootstrapDnsHosts(@Nullable List<InetAddress> bootstrapDnsHosts) {
            this.bootstrapDnsHosts = bootstrapDnsHosts;
            return this;
        }

        public Builder bootstrapDnsHosts(InetAddress ... bootstrapDnsHosts) {
            return this.bootstrapDnsHosts(Arrays.asList(bootstrapDnsHosts));
        }

        public Builder systemDns(Dns systemDns) {
            this.systemDns = systemDns;
            return this;
        }
    }
}

