/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.AbstractTaosDriver;
import com.taosdata.jdbc.TSDBConnection;
import com.taosdata.jdbc.TSDBConstants;
import com.taosdata.jdbc.TSDBDatabaseMetaData;
import com.taosdata.jdbc.TSDBJNIConnector;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class TSDBDriver
extends AbstractTaosDriver {
    @Deprecated
    private static final String URL_PREFIX1 = "jdbc:TSDB://";
    private static final String URL_PREFIX = "jdbc:TAOS://";
    public static final String PROPERTY_KEY_HOST = "host";
    public static final String PROPERTY_KEY_PORT = "port";
    public static final String PROPERTY_KEY_DBNAME = "dbname";
    public static final String PROPERTY_KEY_USER = "user";
    public static final String PROPERTY_KEY_PASSWORD = "password";
    public static final String PROPERTY_KEY_CONFIG_DIR = "cfgdir";
    public static final String PROPERTY_KEY_TIME_ZONE = "timezone";
    public static final String PROPERTY_KEY_LOCALE = "locale";
    public static final String PROPERTY_KEY_CHARSET = "charset";
    public static final String PROPERTY_KEY_BATCH_LOAD = "batchfetch";
    private TSDBDatabaseMetaData dbMetaData = null;

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url == null) {
            throw new SQLException(TSDBConstants.WrapErrMsg("url is not set!"));
        }
        if (!this.acceptsURL(url)) {
            return null;
        }
        Properties props = null;
        props = this.parseURL(url, info);
        if (props == null) {
            return null;
        }
        this.loadTaosConfig(info);
        try {
            TSDBJNIConnector.init((String)props.get(PROPERTY_KEY_CONFIG_DIR), (String)props.get(PROPERTY_KEY_LOCALE), (String)props.get(PROPERTY_KEY_CHARSET), (String)props.get(PROPERTY_KEY_TIME_ZONE));
            TSDBConnection newConn = new TSDBConnection(props, this.dbMetaData);
            return newConn;
        }
        catch (SQLWarning sqlWarning) {
            sqlWarning.printStackTrace();
            TSDBConnection newConn = new TSDBConnection(props, this.dbMetaData);
            return newConn;
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (Exception ex) {
            SQLException sqlEx = new SQLException("SQLException:" + ex.toString());
            sqlEx.initCause(ex);
            throw sqlEx;
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException(TSDBConstants.WrapErrMsg("url is null"));
        }
        return url != null && url.length() > 0 && url.trim().length() > 0 && (url.startsWith(URL_PREFIX) || url.startsWith(URL_PREFIX1));
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        if (this.acceptsURL(url)) {
            info = this.parseURL(url, info);
        }
        return this.getPropertyInfo(info);
    }

    @Override
    public Properties parseURL(String url, Properties defaults) {
        int indexOfColon;
        Properties urlProps;
        Properties properties = urlProps = defaults != null ? defaults : new Properties();
        if (url == null || url.length() <= 0 || url.trim().length() <= 0) {
            return null;
        }
        if (!url.startsWith(URL_PREFIX) && !url.startsWith(URL_PREFIX1)) {
            return null;
        }
        String urlForMeta = url;
        int beginningOfSlashes = url.indexOf("//");
        int index = url.indexOf("?");
        if (index != -1) {
            String paramString = url.substring(index + 1, url.length());
            url = url.substring(0, index);
            StringTokenizer queryParams = new StringTokenizer(paramString, "&");
            while (queryParams.hasMoreElements()) {
                String oneToken = queryParams.nextToken();
                String[] pair = oneToken.split("=");
                if (pair[0] == null || pair[0].trim().length() <= 0 || pair[1] == null || pair[1].trim().length() <= 0) continue;
                urlProps.setProperty(pair[0].trim(), pair[1].trim());
            }
        }
        String dbProductName = url.substring(0, beginningOfSlashes);
        dbProductName = dbProductName.substring(dbProductName.indexOf(":") + 1);
        dbProductName = dbProductName.substring(0, dbProductName.indexOf(":"));
        int indexOfSlash = (url = url.substring(beginningOfSlashes + 2)).indexOf("/");
        if (indexOfSlash != -1) {
            if (indexOfSlash + 1 < url.length()) {
                urlProps.setProperty(PROPERTY_KEY_DBNAME, url.substring(indexOfSlash + 1));
            }
            url = url.substring(0, indexOfSlash);
        }
        if ((indexOfColon = url.indexOf(":")) != -1) {
            if (indexOfColon + 1 < url.length()) {
                urlProps.setProperty(PROPERTY_KEY_PORT, url.substring(indexOfColon + 1));
            }
            url = url.substring(0, indexOfColon);
        }
        if (url != null && url.length() > 0 && url.trim().length() > 0) {
            urlProps.setProperty(PROPERTY_KEY_HOST, url);
        }
        this.dbMetaData = new TSDBDatabaseMetaData(urlForMeta, urlProps.getProperty(PROPERTY_KEY_USER));
        return urlProps;
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    static {
        try {
            DriverManager.registerDriver(new TSDBDriver());
        }
        catch (SQLException E) {
            throw new RuntimeException(TSDBConstants.WrapErrMsg("can't register tdengine jdbc driver!"));
        }
    }
}

