/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taosdata.jdbc.TSDBConstants;
import com.taosdata.jdbc.rs.RestfulResultSetMetaData;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class RestfulResultSet
implements ResultSet {
    private volatile boolean isClosed;
    private int pos = -1;
    private final String database;
    private final Statement statement;
    private ArrayList<ArrayList<Object>> resultSet = new ArrayList();
    private ArrayList<String> columnNames = new ArrayList();
    private ArrayList<Field> columns = new ArrayList();
    private RestfulResultSetMetaData metaData;

    public RestfulResultSet(String database, Statement statement, JSONObject resultJson) {
        this.database = database;
        this.statement = statement;
        JSONArray data = resultJson.getJSONArray("data");
        for (int columnIndex = 0; columnIndex < data.size(); ++columnIndex) {
            ArrayList<String> oneRow = new ArrayList<String>();
            JSONArray one = data.getJSONArray(columnIndex);
            for (int j = 0; j < one.size(); ++j) {
                oneRow.add(one.getString(j));
            }
            this.resultSet.add(oneRow);
        }
        JSONArray head = resultJson.getJSONArray("head");
        for (int i = 0; i < head.size(); ++i) {
            String name = head.getString(i);
            this.columnNames.add(name);
            this.columns.add(new Field(name, "", 0, ""));
        }
        this.metaData = new RestfulResultSetMetaData(this.database, this.columns, this);
    }

    public RestfulResultSet(String database, Statement statement, JSONObject resultJson, List<JSONObject> fieldJson) {
        this(database, statement, resultJson);
        ArrayList<Field> newColumns = new ArrayList<Field>();
        for (Field column : this.columns) {
            Field field = this.findField(column.name, fieldJson);
            if (field != null) {
                newColumns.add(field);
                continue;
            }
            newColumns.add(column);
        }
        this.columns = newColumns;
        this.metaData = new RestfulResultSetMetaData(this.database, this.columns, this);
    }

    public Field findField(String columnName, List<JSONObject> fieldJsonList) {
        for (JSONObject fieldJSON : fieldJsonList) {
            JSONArray fieldDataJson = fieldJSON.getJSONArray("data");
            for (int i = 0; i < fieldDataJson.size(); ++i) {
                JSONArray field = fieldDataJson.getJSONArray(i);
                if (!columnName.equalsIgnoreCase(field.getString(0))) continue;
                return new Field(field.getString(0), field.getString(1), field.getInteger(2), field.getString(3));
            }
        }
        return null;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        ++this.pos;
        return this.pos <= this.resultSet.size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Class<RestfulResultSet> clazz = RestfulResultSet.class;
        synchronized (RestfulResultSet.class) {
            this.isClosed = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        return this.resultSet.isEmpty();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        if (columnIndex > this.resultSet.get(this.pos).size()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("Column Index out of range, " + columnIndex + " > " + this.resultSet.get(this.pos).size()));
        }
        columnIndex = this.getTrueColumnIndex(columnIndex);
        return this.resultSet.get(this.pos).get(columnIndex).toString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        int result = this.getInt(columnIndex = this.getTrueColumnIndex(columnIndex));
        return result != 0;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        columnIndex = this.getTrueColumnIndex(columnIndex);
        return Short.parseShort(this.resultSet.get(this.pos).get(columnIndex).toString());
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        columnIndex = this.getTrueColumnIndex(columnIndex);
        return Integer.parseInt(this.resultSet.get(this.pos).get(columnIndex).toString());
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        columnIndex = this.getTrueColumnIndex(columnIndex);
        return Long.parseLong(this.resultSet.get(this.pos).get(columnIndex).toString());
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        columnIndex = this.getTrueColumnIndex(columnIndex);
        return Float.parseFloat(this.resultSet.get(this.pos).get(columnIndex).toString());
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        columnIndex = this.getTrueColumnIndex(columnIndex);
        return Double.parseDouble(this.resultSet.get(this.pos).get(columnIndex).toString());
    }

    private int getTrueColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex < 1) {
            throw new SQLException("Column Index out of range, " + columnIndex + " < 1");
        }
        int numOfCols = this.resultSet.get(this.pos).size();
        if (columnIndex > numOfCols) {
            throw new SQLException("Column Index out of range, " + columnIndex + " > " + numOfCols);
        }
        return columnIndex - 1;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        columnIndex = this.getTrueColumnIndex(columnIndex);
        String strDate = this.resultSet.get(this.pos).get(columnIndex).toString();
        return Timestamp.valueOf(strDate);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        return this.metaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        int columnIndex = this.columnNames.indexOf(columnLabel);
        if (columnIndex == -1) {
            throw new SQLException("cannot find Column in resultSet");
        }
        return columnIndex + 1;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        return this.pos == -1 && this.resultSet.size() != 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        return this.pos >= this.resultSet.size() && this.resultSet.size() != 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        return this.pos == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        if (this.resultSet.size() == 0) {
            return false;
        }
        return this.pos == this.resultSet.size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        RestfulResultSet restfulResultSet = this;
        synchronized (restfulResultSet) {
            if (this.resultSet.size() > 0) {
                this.pos = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLast() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        RestfulResultSet restfulResultSet = this;
        synchronized (restfulResultSet) {
            if (this.resultSet.size() > 0) {
                this.pos = this.resultSet.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean first() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        if (this.resultSet.size() == 0) {
            return false;
        }
        RestfulResultSet restfulResultSet = this;
        synchronized (restfulResultSet) {
            this.pos = 0;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean last() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        if (this.resultSet.size() == 0) {
            return false;
        }
        RestfulResultSet restfulResultSet = this;
        synchronized (restfulResultSet) {
            this.pos = this.resultSet.size() - 1;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() throws SQLException {
        int row;
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        RestfulResultSet restfulResultSet = this;
        synchronized (restfulResultSet) {
            if (this.pos < 0 || this.pos >= this.resultSet.size()) {
                return 0;
            }
            row = this.pos + 1;
        }
        return row;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new SQLException("invalid variables");
        }
        if (this.getType() != 1003 || direction != 1000) {
            throw new SQLException("this operation is NOT supported currently!");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        if (rows < 0) {
            throw new SQLException("invalid variables");
        }
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        return this.resultSet.size();
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        return this.statement;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public int getHoldability() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw new SQLException("Unable to unwrap to " + iface.toString());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("resultSet is closed."));
        }
        return iface.isInstance(this);
    }

    public class Field {
        String name;
        String type;
        int length;
        String note;

        public Field(String name, String type, int length, String note) {
            this.name = name;
            this.type = type;
            this.length = length;
            this.note = note;
        }
    }
}

