/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.taosdata.jdbc.rs.RestfulResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;

public class RestfulResultSetMetaData
implements ResultSetMetaData {
    private final String database;
    private ArrayList<RestfulResultSet.Field> fields;
    private final RestfulResultSet resultSet;

    public RestfulResultSetMetaData(String database, ArrayList<RestfulResultSet.Field> fields, RestfulResultSet resultSet) {
        this.database = database;
        this.fields = fields;
        this.resultSet = resultSet;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.fields.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        if (column == 1) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        String type;
        switch (type = this.fields.get((int)(column - 1)).type.toUpperCase()) {
            case "TINYINT": 
            case "SMALLINT": 
            case "INT": 
            case "BIGINT": 
            case "FLOAT": 
            case "DOUBLE": {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.fields.get((int)(column - 1)).length;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.fields.get((int)(column - 1)).name;
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.fields.get((int)(column - 1)).name;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        String type;
        switch (type = this.fields.get((int)(column - 1)).type.toUpperCase()) {
            case "FLOAT": {
                return 5;
            }
            case "DOUBLE": {
                return 9;
            }
            case "BINARY": 
            case "NCHAR": {
                return this.fields.get((int)(column - 1)).length;
            }
        }
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        String type;
        switch (type = this.fields.get((int)(column - 1)).type.toUpperCase()) {
            case "FLOAT": {
                return 5;
            }
            case "DOUBLE": {
                return 9;
            }
        }
        return 0;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.database;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        String type;
        switch (type = this.fields.get((int)(column - 1)).type.toUpperCase()) {
            case "BOOL": {
                return 16;
            }
            case "TINYINT": {
                return -6;
            }
            case "SMALLINT": {
                return 5;
            }
            case "INT": {
                return 4;
            }
            case "BIGINT": {
                return -5;
            }
            case "FLOAT": {
                return 6;
            }
            case "DOUBLE": {
                return 8;
            }
            case "BINARY": {
                return -2;
            }
            case "TIMESTAMP": {
                return 93;
            }
            case "NCHAR": {
                return -15;
            }
        }
        throw new SQLException("invalid variables");
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        String type = this.fields.get((int)(column - 1)).type;
        return type.toUpperCase();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        String type = this.fields.get((int)(column - 1)).type;
        String columnClassName = "";
        switch (type) {
            case "BOOL": {
                return Boolean.class.getName();
            }
            case "TINYINT": 
            case "SMALLINT": {
                return Short.class.getName();
            }
            case "INT": {
                return Integer.class.getName();
            }
            case "BIGINT": {
                return Long.class.getName();
            }
            case "FLOAT": {
                return Float.class.getName();
            }
            case "DOUBLE": {
                return Double.class.getName();
            }
            case "TIMESTAMP": {
                return Timestamp.class.getName();
            }
            case "BINARY": 
            case "NCHAR": {
                return String.class.getName();
            }
        }
        return columnClassName;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw new SQLException("Unable to unwrap to " + iface.toString());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

