/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taosdata.jdbc.TSDBConstants;
import com.taosdata.jdbc.rs.RestfulConnection;
import com.taosdata.jdbc.rs.RestfulResultSet;
import com.taosdata.jdbc.rs.util.HttpClientPoolUtil;
import com.taosdata.jdbc.utils.SqlSyntaxValidator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public class RestfulStatement
implements Statement {
    private static final String STATEMENT_CLOSED = "Statement already closed.";
    private boolean closed;
    private String database;
    private final RestfulConnection conn;
    private volatile RestfulResultSet resultSet;
    private volatile int affectedRows;
    private volatile boolean closeOnCompletion;

    public RestfulStatement(RestfulConnection conn, String database) {
        this.conn = conn;
        this.database = database;
    }

    private String[] parseTableIdentifier(String sql) {
        sql = sql.trim().toLowerCase();
        String[] ret = null;
        if (sql.contains("where")) {
            sql = sql.substring(0, sql.indexOf("where"));
        }
        if (sql.contains("interval")) {
            sql = sql.substring(0, sql.indexOf("interval"));
        }
        if (sql.contains("fill")) {
            sql = sql.substring(0, sql.indexOf("fill"));
        }
        if (sql.contains("sliding")) {
            sql = sql.substring(0, sql.indexOf("sliding"));
        }
        if (sql.contains("group by")) {
            sql = sql.substring(0, sql.indexOf("group by"));
        }
        if (sql.contains("order by")) {
            sql = sql.substring(0, sql.indexOf("order by"));
        }
        if (sql.contains("slimit")) {
            sql = sql.substring(0, sql.indexOf("slimit"));
        }
        if (sql.contains("limit")) {
            sql = sql.substring(0, sql.indexOf("limit"));
        }
        if (sql.contains("from")) {
            sql = sql.substring(sql.indexOf("from") + 4).trim();
            return Arrays.asList(sql.split(",")).stream().map(tableIdentifier -> {
                if ((tableIdentifier = tableIdentifier.trim()).contains(" ")) {
                    tableIdentifier = tableIdentifier.substring(0, tableIdentifier.indexOf(" "));
                }
                return tableIdentifier;
            }).collect(Collectors.joining(",")).split(",");
        }
        return ret;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("statement already closed");
        }
        if (!SqlSyntaxValidator.isValidForExecuteQuery(sql)) {
            throw new SQLException("not a valid sql for executeQuery: " + sql);
        }
        String url = "http://" + this.conn.getHost() + ":" + this.conn.getPort() + "/rest/sql";
        if (SqlSyntaxValidator.isDatabaseUnspecifiedQuery(sql)) {
            return this.executeOneQuery(url, sql);
        }
        if (this.database == null || this.database.isEmpty()) {
            throw new SQLException("Database not specified or available");
        }
        HttpClientPoolUtil.execute(url, "use " + this.database);
        return this.executeOneQuery(url, sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("statement already closed");
        }
        if (!SqlSyntaxValidator.isValidForExecuteUpdate(sql)) {
            throw new SQLException("not a valid sql for executeUpdate: " + sql);
        }
        String url = "http://" + this.conn.getHost() + ":" + this.conn.getPort() + "/rest/sql";
        if (SqlSyntaxValidator.isDatabaseUnspecifiedUpdate(sql)) {
            return this.executeOneUpdate(url, sql);
        }
        if (this.database == null || this.database.isEmpty()) {
            throw new SQLException("Database not specified or available");
        }
        HttpClientPoolUtil.execute(url, "use " + this.database);
        return this.executeOneUpdate(url, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Class<RestfulStatement> clazz = RestfulStatement.class;
        synchronized (RestfulStatement.class) {
            if (!this.isClosed()) {
                this.closed = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_CLOSED);
        }
        return 16384;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_CLOSED);
        }
        if (max < 0) {
            throw new SQLException("invalid variables");
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_CLOSED);
        }
        return 0;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_CLOSED);
        }
        if (max < 0) {
            throw new SQLException("invalid variables");
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_CLOSED);
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_CLOSED);
        }
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_CLOSED);
        }
        if (seconds < 0) {
            throw new SQLException("invalid variables");
        }
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_CLOSED);
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_CLOSED);
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_CLOSED);
        }
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Invalid method call on a closed statement.");
        }
        if (!SqlSyntaxValidator.isValidForExecute(sql)) {
            throw new SQLException("not a valid sql for execute: " + sql);
        }
        String url = "http://" + this.conn.getHost() + ":" + this.conn.getPort() + "/rest/sql";
        if (SqlSyntaxValidator.isUseSql(sql)) {
            HttpClientPoolUtil.execute(url, sql);
            this.database = sql.trim().replace("use", "").trim();
            this.conn.setCatalog(this.database);
        } else if (SqlSyntaxValidator.isDatabaseUnspecifiedQuery(sql)) {
            this.executeOneQuery(url, sql);
        } else if (SqlSyntaxValidator.isDatabaseUnspecifiedUpdate(sql)) {
            this.executeOneUpdate(url, sql);
        } else if (SqlSyntaxValidator.isValidForExecuteQuery(sql)) {
            this.executeQuery(sql);
        } else {
            this.executeUpdate(sql);
        }
        return true;
    }

    private ResultSet executeOneQuery(String url, String sql) throws SQLException {
        if (!SqlSyntaxValidator.isValidForExecuteQuery(sql)) {
            throw new SQLException("not a select sql for executeQuery: " + sql);
        }
        String result = HttpClientPoolUtil.execute(url, sql);
        JSONObject resultJson = JSON.parseObject((String)result);
        if (resultJson.getString("status").equals("error")) {
            throw new SQLException(TSDBConstants.WrapErrMsg("SQL execution error: " + resultJson.getString("desc") + "\nerror code: " + resultJson.getString("code")));
        }
        String[] tableIdentifiers = this.parseTableIdentifier(sql);
        if (tableIdentifiers != null) {
            ArrayList<JSONObject> fieldJsonList = new ArrayList<JSONObject>();
            for (String tableIdentifier : tableIdentifiers) {
                String fields = HttpClientPoolUtil.execute(url, "DESCRIBE " + tableIdentifier);
                JSONObject fieldJson = JSON.parseObject((String)fields);
                if (fieldJson.getString("status").equals("error")) {
                    throw new SQLException(TSDBConstants.WrapErrMsg("SQL execution error: " + fieldJson.getString("desc") + "\nerror code: " + fieldJson.getString("code")));
                }
                fieldJsonList.add(fieldJson);
            }
            this.resultSet = new RestfulResultSet(this.database, this, resultJson, fieldJsonList);
        } else {
            this.resultSet = new RestfulResultSet(this.database, this, resultJson);
        }
        this.affectedRows = 0;
        return this.resultSet;
    }

    private int executeOneUpdate(String url, String sql) throws SQLException {
        if (!SqlSyntaxValidator.isValidForExecuteUpdate(sql)) {
            throw new SQLException("not a valid sql for executeUpdate: " + sql);
        }
        String result = HttpClientPoolUtil.execute(url, sql);
        JSONObject jsonObject = JSON.parseObject((String)result);
        if (jsonObject.getString("status").equals("error")) {
            throw new SQLException(TSDBConstants.WrapErrMsg("SQL execution error: " + jsonObject.getString("desc") + "\nerror code: " + jsonObject.getString("code")));
        }
        this.resultSet = null;
        this.affectedRows = Integer.parseInt(jsonObject.getString("rows"));
        return this.affectedRows;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_CLOSED);
        }
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Invalid method call on a closed statement.");
        }
        return this.affectedRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new SQLException("invalid variables");
        }
        this.resultSet.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.resultSet.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_CLOSED);
        }
        if (rows < 0) {
            throw new SQLException("invalid variables");
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_CLOSED);
        }
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_CLOSED);
        }
        return this.resultSet.getConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_CLOSED);
        }
        return this.resultSet.getType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_CLOSED);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return new int[0];
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_CLOSED);
        }
        return this.conn;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_CLOSED);
        }
        if (this.resultSet == null) {
            return false;
        }
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("this operation is NOT supported currently!");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_CLOSED);
        }
        return this.resultSet.getHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_CLOSED);
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_CLOSED);
        }
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_CLOSED);
        }
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(STATEMENT_CLOSED);
        }
        return this.closeOnCompletion;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw new SQLException("Unable to unwrap to " + iface.toString());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

