/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.TSDBError;
import java.sql.SQLException;

public abstract class TSDBConstants {
    public static final long JNI_NULL_POINTER = 0L;
    public static final int JNI_SUCCESS = 0;
    public static final int JNI_TDENGINE_ERROR = -1;
    public static final int JNI_CONNECTION_NULL = -2;
    public static final int JNI_RESULT_SET_NULL = -3;
    public static final int JNI_NUM_OF_FIELDS_0 = -4;
    public static final int JNI_SQL_NULL = -5;
    public static final int JNI_FETCH_END = -6;
    public static final int JNI_OUT_OF_MEMORY = -7;
    public static final int TSDB_DATA_TYPE_BOOL = 1;
    public static final int TSDB_DATA_TYPE_TINYINT = 2;
    public static final int TSDB_DATA_TYPE_SMALLINT = 3;
    public static final int TSDB_DATA_TYPE_INT = 4;
    public static final int TSDB_DATA_TYPE_BIGINT = 5;
    public static final int TSDB_DATA_TYPE_FLOAT = 6;
    public static final int TSDB_DATA_TYPE_DOUBLE = 7;
    public static final int TSDB_DATA_TYPE_BINARY = 8;
    public static final int TSDB_DATA_TYPE_TIMESTAMP = 9;
    public static final int TSDB_DATA_TYPE_NCHAR = 10;
    public static final int TSDB_DATA_TYPE_UTINYINT = 11;
    public static final int TSDB_DATA_TYPE_USMALLINT = 12;
    public static final int TSDB_DATA_TYPE_UINT = 13;
    public static final int TSDB_DATA_TYPE_UBIGINT = 14;
    public static final int maxFieldSize = 16384;

    public static int taosType2JdbcType(int taosType) throws SQLException {
        switch (taosType) {
            case 1: {
                return 16;
            }
            case 2: 
            case 11: {
                return -6;
            }
            case 3: 
            case 12: {
                return 5;
            }
            case 4: 
            case 13: {
                return 4;
            }
            case 5: 
            case 14: {
                return -5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return -2;
            }
            case 9: {
                return 93;
            }
            case 10: {
                return -15;
            }
        }
        throw TSDBError.createSQLException(8981);
    }

    public static String taosType2JdbcTypeName(int taosType) throws SQLException {
        switch (taosType) {
            case 1: {
                return "BOOL";
            }
            case 2: 
            case 11: {
                return "TINYINT";
            }
            case 3: 
            case 12: {
                return "SMALLINT";
            }
            case 4: 
            case 13: {
                return "INT";
            }
            case 5: 
            case 14: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "DOUBLE";
            }
            case 8: {
                return "BINARY";
            }
            case 9: {
                return "TIMESTAMP";
            }
            case 10: {
                return "NCHAR";
            }
        }
        throw TSDBError.createSQLException(8981);
    }

    public static int jdbcType2TaosType(int jdbcType) throws SQLException {
        switch (jdbcType) {
            case 16: {
                return 1;
            }
            case -6: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case -5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case -2: {
                return 8;
            }
            case 93: {
                return 9;
            }
            case -15: {
                return 10;
            }
        }
        throw TSDBError.createSQLException(8975);
    }

    public static String jdbcType2TaosTypeName(int jdbcType) throws SQLException {
        switch (jdbcType) {
            case 16: {
                return "BOOL";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INT";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 8: {
                return "DOUBLE";
            }
            case -2: {
                return "BINARY";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -15: {
                return "NCHAR";
            }
        }
        throw TSDBError.createSQLException(8975);
    }
}

