/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.rs.RestfulConnection;
import com.taosdata.jdbc.rs.RestfulParameterMetaData;
import com.taosdata.jdbc.rs.RestfulStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class RestfulPreparedStatement
extends RestfulStatement
implements PreparedStatement {
    private ParameterMetaData parameterMetaData;
    private final String rawSql;
    private Object[] parameters;
    private boolean isPrepared;

    public RestfulPreparedStatement(RestfulConnection conn, String database, String sql) {
        super(conn, database);
        this.rawSql = sql;
        if (sql.contains("?")) {
            int parameterCnt = 0;
            for (int i = 0; i < sql.length(); ++i) {
                if ('?' != sql.charAt(i)) continue;
                ++parameterCnt;
            }
            this.parameters = new Object[parameterCnt];
            this.isPrepared = true;
        }
        this.parameterMetaData = new RestfulParameterMetaData(this.parameters);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (!this.isPrepared) {
            return this.executeQuery(this.rawSql);
        }
        String sql = this.getNativeSql(this.rawSql);
        return this.executeQuery(sql);
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (!this.isPrepared) {
            return this.executeUpdate(this.rawSql);
        }
        String sql = this.getNativeSql(this.rawSql);
        return this.executeUpdate(sql);
    }

    private String getNativeSql(String rawSql) throws SQLException {
        String sql = rawSql;
        for (int i = 0; i < this.parameters.length; ++i) {
            Object para = this.parameters[i];
            if (para != null) {
                String paraStr = para instanceof byte[] ? new String((byte[])para, Charset.forName("UTF-8")) : para.toString();
                if (para instanceof Timestamp || para instanceof String || para instanceof byte[]) {
                    paraStr = paraStr.replaceAll("'", "\\\\\\\\'");
                    paraStr = "'" + paraStr + "'";
                }
                sql = sql.replaceFirst("[?]", paraStr);
                continue;
            }
            sql = sql.replaceFirst("[?]", "NULL");
        }
        this.clearParameters();
        return sql;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.setObject(parameterIndex, "NULL");
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.setObject(parameterIndex, Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void clearParameters() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.parameters = new Object[this.parameters.length];
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (parameterIndex < 1 && parameterIndex >= this.parameters.length) {
            throw TSDBError.createSQLException(8973);
        }
        this.parameters[parameterIndex - 1] = x;
    }

    @Override
    public boolean execute() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (!this.isPrepared) {
            return this.execute(this.rawSql);
        }
        String sql = this.getNativeSql(this.rawSql);
        return this.execute(sql);
    }

    @Override
    public void addBatch() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        String sql = this.getNativeSql(this.rawSql);
        this.addBatch(sql);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.parameterMetaData;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }
}

