/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taosdata.jdbc.AbstractStatement;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.rs.RestfulConnection;
import com.taosdata.jdbc.rs.RestfulResultSet;
import com.taosdata.jdbc.utils.HttpClientPoolUtil;
import com.taosdata.jdbc.utils.SqlSyntaxValidator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class RestfulStatement
extends AbstractStatement {
    private boolean closed;
    private String database;
    private final RestfulConnection conn;
    private volatile RestfulResultSet resultSet;
    private volatile int affectedRows;

    public RestfulStatement(RestfulConnection conn, String database) {
        this.conn = conn;
        this.database = database;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (!SqlSyntaxValidator.isValidForExecuteQuery(sql)) {
            throw TSDBError.createSQLException(8969, "not a valid sql for executeQuery: " + sql);
        }
        if (SqlSyntaxValidator.isDatabaseUnspecifiedQuery(sql)) {
            return this.executeOneQuery(sql);
        }
        return this.executeOneQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (!SqlSyntaxValidator.isValidForExecuteUpdate(sql)) {
            throw TSDBError.createSQLException(8971, "not a valid sql for executeUpdate: " + sql);
        }
        String url = "http://" + this.conn.getHost() + ":" + this.conn.getPort() + "/rest/sql";
        if (SqlSyntaxValidator.isDatabaseUnspecifiedUpdate(sql)) {
            return this.executeOneUpdate(url, sql);
        }
        return this.executeOneUpdate(url, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Class<RestfulStatement> clazz = RestfulStatement.class;
        synchronized (RestfulStatement.class) {
            if (!this.isClosed()) {
                this.closed = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (!SqlSyntaxValidator.isValidForExecute(sql)) {
            throw TSDBError.createSQLException(8972, "not a valid sql for execute: " + sql);
        }
        boolean result = true;
        String url = "http://" + this.conn.getHost() + ":" + this.conn.getPort() + "/rest/sql";
        if (this.conn.getClientInfo("timestampFormat").equals("TIMESTAMP")) {
            url = "http://" + this.conn.getHost() + ":" + this.conn.getPort() + "/rest/sqlt";
        }
        if (this.conn.getClientInfo("timestampFormat").equals("UTC")) {
            url = "http://" + this.conn.getHost() + ":" + this.conn.getPort() + "/rest/sqlutc";
        }
        if (SqlSyntaxValidator.isUseSql(sql)) {
            HttpClientPoolUtil.execute(url, sql);
            this.database = sql.trim().replace("use", "").trim();
            this.conn.setCatalog(this.database);
            result = false;
        } else if (SqlSyntaxValidator.isDatabaseUnspecifiedQuery(sql)) {
            this.executeOneQuery(sql);
        } else if (SqlSyntaxValidator.isDatabaseUnspecifiedUpdate(sql)) {
            this.executeOneUpdate(url, sql);
            result = false;
        } else if (SqlSyntaxValidator.isValidForExecuteQuery(sql)) {
            this.executeQuery(sql);
        } else {
            this.executeUpdate(sql);
            result = false;
        }
        return result;
    }

    private ResultSet executeOneQuery(String sql) throws SQLException {
        String result;
        JSONObject resultJson;
        if (!SqlSyntaxValidator.isValidForExecuteQuery(sql)) {
            throw TSDBError.createSQLException(8969, "not a valid sql for executeQuery: " + sql);
        }
        String url = "http://" + this.conn.getHost() + ":" + this.conn.getPort() + "/rest/sql";
        String timestampFormat = this.conn.getClientInfo("timestampFormat");
        if ("TIMESTAMP".equalsIgnoreCase(timestampFormat)) {
            url = "http://" + this.conn.getHost() + ":" + this.conn.getPort() + "/rest/sqlt";
        }
        if ("UTC".equalsIgnoreCase(timestampFormat)) {
            url = "http://" + this.conn.getHost() + ":" + this.conn.getPort() + "/rest/sqlutc";
        }
        if ((resultJson = JSON.parseObject((String)(result = HttpClientPoolUtil.execute(url, sql)))).getString("status").equals("error")) {
            throw TSDBError.createSQLException(resultJson.getInteger("code"), resultJson.getString("desc"));
        }
        this.resultSet = new RestfulResultSet(this.database, this, resultJson);
        this.affectedRows = 0;
        return this.resultSet;
    }

    private int executeOneUpdate(String url, String sql) throws SQLException {
        if (!SqlSyntaxValidator.isValidForExecuteUpdate(sql)) {
            throw TSDBError.createSQLException(8971, "not a valid sql for executeUpdate: " + sql);
        }
        String result = HttpClientPoolUtil.execute(url, sql);
        JSONObject jsonObject = JSON.parseObject((String)result);
        if (jsonObject.getString("status").equals("error")) {
            throw TSDBError.createSQLException(jsonObject.getInteger("code"), jsonObject.getString("desc"));
        }
        this.resultSet = null;
        this.affectedRows = this.checkJsonResultSet(jsonObject);
        return this.affectedRows;
    }

    private int checkJsonResultSet(JSONObject jsonObject) {
        JSONArray head = jsonObject.getJSONArray("head");
        JSONArray data = jsonObject.getJSONArray("data");
        int rows = Integer.parseInt(jsonObject.getString("rows"));
        if (head.size() == 1 && "affected_rows".equals(head.getString(0)) && data.size() == 1 && data.getJSONArray(0).getInteger(0) == 0 && rows == 1) {
            return 0;
        }
        return rows;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.affectedRows;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.conn;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }
}

