/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class AbstractDriver
implements Driver {
    protected DriverPropertyInfo[] getPropertyInfo(Properties info) {
        DriverPropertyInfo hostProp = new DriverPropertyInfo("host", info.getProperty("host"));
        hostProp.required = false;
        hostProp.description = "Hostname";
        DriverPropertyInfo portProp = new DriverPropertyInfo("port", info.getProperty("port"));
        portProp.required = false;
        portProp.description = "Port";
        DriverPropertyInfo dbProp = new DriverPropertyInfo("dbname", info.getProperty("dbname"));
        dbProp.required = false;
        dbProp.description = "Database name";
        DriverPropertyInfo userProp = new DriverPropertyInfo("user", info.getProperty("user"));
        userProp.required = true;
        userProp.description = "User";
        DriverPropertyInfo passwordProp = new DriverPropertyInfo("password", info.getProperty("password"));
        passwordProp.required = true;
        passwordProp.description = "Password";
        DriverPropertyInfo[] propertyInfo = new DriverPropertyInfo[]{hostProp, portProp, dbProp, userProp, passwordProp};
        return propertyInfo;
    }

    protected Properties parseURL(String url, Properties defaults) {
        int indexOfColon;
        Properties urlProps = defaults != null ? defaults : new Properties();
        int beginningOfSlashes = url.indexOf("//");
        int index = url.indexOf("?");
        if (index != -1) {
            String paramString = url.substring(index + 1);
            url = url.substring(0, index);
            StringTokenizer queryParams = new StringTokenizer(paramString, "&");
            while (queryParams.hasMoreElements()) {
                String parameterValuePair = queryParams.nextToken();
                int indexOfEqual = parameterValuePair.indexOf("=");
                String parameter = null;
                String value = null;
                if (indexOfEqual != -1) {
                    parameter = parameterValuePair.substring(0, indexOfEqual);
                    if (indexOfEqual + 1 < parameterValuePair.length()) {
                        value = parameterValuePair.substring(indexOfEqual + 1);
                    }
                }
                if (value == null || value.length() <= 0 || parameter == null || parameter.length() <= 0) continue;
                urlProps.setProperty(parameter, value);
            }
        }
        String dbProductName = url.substring(0, beginningOfSlashes);
        dbProductName = dbProductName.substring(dbProductName.indexOf(":") + 1);
        dbProductName = dbProductName.substring(0, dbProductName.indexOf(":"));
        urlProps.setProperty("productName", dbProductName);
        url = url.substring(beginningOfSlashes + 2);
        int indexOfSlash = url.indexOf("/");
        if (indexOfSlash != -1) {
            if (indexOfSlash + 1 < url.length()) {
                urlProps.setProperty("dbname", url.substring(indexOfSlash + 1));
            }
            url = url.substring(0, indexOfSlash);
        }
        if ((indexOfColon = url.indexOf(":")) != -1) {
            if (indexOfColon + 1 < url.length()) {
                urlProps.setProperty("port", url.substring(indexOfColon + 1));
            }
            url = url.substring(0, indexOfColon);
        }
        if (url != null && url.length() > 0 && url.trim().length() > 0) {
            urlProps.setProperty("host", url);
        }
        return urlProps;
    }
}

