/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.WrapperImpl;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public abstract class AbstractResultSet
extends WrapperImpl
implements ResultSet {
    private int fetchSize;
    protected boolean wasNull;

    protected void checkAvailability(int columnIndex, int bounds) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        if (columnIndex < 1) {
            throw TSDBError.createSQLException(8973, "Column Index out of range, " + columnIndex + " < 1");
        }
        if (columnIndex > bounds) {
            throw TSDBError.createSQLException(8973, "Column Index out of range, " + columnIndex + " > " + bounds);
        }
    }

    @Override
    public abstract boolean next() throws SQLException;

    @Override
    public abstract void close() throws SQLException;

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public abstract String getString(int var1) throws SQLException;

    @Override
    public abstract boolean getBoolean(int var1) throws SQLException;

    @Override
    public abstract byte getByte(int var1) throws SQLException;

    @Override
    public abstract short getShort(int var1) throws SQLException;

    @Override
    public abstract int getInt(int var1) throws SQLException;

    @Override
    public abstract long getLong(int var1) throws SQLException;

    @Override
    public abstract float getFloat(int var1) throws SQLException;

    @Override
    public abstract double getDouble(int var1) throws SQLException;

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getBigDecimal(columnIndex);
    }

    @Override
    public abstract byte[] getBytes(int var1) throws SQLException;

    @Override
    public abstract Date getDate(int var1) throws SQLException;

    @Override
    public abstract Time getTime(int var1) throws SQLException;

    @Override
    public abstract Timestamp getTimestamp(int var1) throws SQLException;

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public abstract ResultSetMetaData getMetaData() throws SQLException;

    @Override
    public abstract Object getObject(int var1) throws SQLException;

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public abstract int findColumn(String var1) throws SQLException;

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public abstract BigDecimal getBigDecimal(int var1) throws SQLException;

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public abstract boolean isBeforeFirst() throws SQLException;

    @Override
    public abstract boolean isAfterLast() throws SQLException;

    @Override
    public abstract boolean isFirst() throws SQLException;

    @Override
    public abstract boolean isLast() throws SQLException;

    @Override
    public abstract void beforeFirst() throws SQLException;

    @Override
    public abstract void afterLast() throws SQLException;

    @Override
    public abstract boolean first() throws SQLException;

    @Override
    public abstract boolean last() throws SQLException;

    @Override
    public abstract int getRow() throws SQLException;

    @Override
    public abstract boolean absolute(int var1) throws SQLException;

    @Override
    public abstract boolean relative(int var1) throws SQLException;

    @Override
    public abstract boolean previous() throws SQLException;

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (rows < 0) {
            throw TSDBError.createSQLException(8963);
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean rowInserted() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void insertRow() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateRow() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void deleteRow() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void refreshRow() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public abstract Statement getStatement() throws SQLException;

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), map);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public abstract Timestamp getTimestamp(int var1, Calendar var2) throws SQLException;

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public int getHoldability() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return 1;
    }

    @Override
    public abstract boolean isClosed() throws SQLException;

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public abstract String getNString(int var1) throws SQLException;

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getNString(this.findColumn(columnLabel));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }
}

