/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.AbstractStatement;
import com.taosdata.jdbc.TSDBConnection;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TSDBJNIConnector;
import com.taosdata.jdbc.TSDBResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TSDBStatement
extends AbstractStatement {
    private TSDBJNIConnector connector;
    private boolean isClosed;
    private int affectedRows = -1;
    private TSDBConnection connection;
    private TSDBResultSet resultSet;

    public void setConnection(TSDBConnection connection) {
        this.connection = connection;
    }

    TSDBStatement(TSDBConnection connection, TSDBJNIConnector connector) {
        this.connection = connection;
        this.connector = connector;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        long pSql = this.connector.executeQuery(sql);
        if (this.connector.isUpdateQuery(pSql)) {
            this.connector.freeResultSet(pSql);
            throw TSDBError.createSQLException(8967);
        }
        TSDBResultSet res = new TSDBResultSet(this, this.connector, pSql);
        res.setBatchFetch(this.connection.getBatchFetch());
        return res;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        long pSql = this.connector.executeQuery(sql);
        if (!this.connector.isUpdateQuery(pSql)) {
            this.connector.freeResultSet(pSql);
            throw TSDBError.createSQLException(8968);
        }
        int affectedRows = this.connector.getAffectedRows(pSql);
        this.connector.freeResultSet(pSql);
        return affectedRows;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.resultSet != null && !this.resultSet.isClosed()) {
            this.resultSet.close();
        }
        this.isClosed = true;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        long pSql = this.connector.executeQuery(sql);
        if (this.connector.isUpdateQuery(pSql)) {
            this.affectedRows = this.connector.getAffectedRows(pSql);
            this.connector.freeResultSet(pSql);
            return false;
        }
        this.resultSet = new TSDBResultSet(this, this.connector, pSql);
        this.resultSet.setBatchFetch(this.connection.getBatchFetch());
        return true;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.affectedRows;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (this.connector == null) {
            throw TSDBError.createSQLException(9044);
        }
        return this.connection;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }
}

